/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.persistence.api;

import com.google.common.base.MoreObjects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.RuleDefinition;

@Table(name="classification_rules")
@Entity
public class Rule
implements RuleDefinition {
    public static final int MIN_PORT_VALUE = 0;
    public static final int MAX_PORT_VALUE = 65536;
    @Id
    @SequenceGenerator(name="ruleSequence", sequenceName="ruleNxtId")
    @GeneratedValue(generator="ruleSequence")
    private Integer id;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="dst_address")
    private String dstAddress;
    @Column(name="dst_port")
    private String dstPort;
    @Column(name="src_port")
    private String srcPort;
    @Column(name="src_address")
    private String srcAddress;
    @Column(name="exporter_filter")
    private String exporterFilter;
    @Column(name="protocol")
    private String protocol;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="groupId")
    private Group group;
    @Column(name="position", nullable=false)
    private int position;
    @Column(name="omnidirectional")
    private boolean omnidirectional;

    public Rule() {
    }

    public Rule(String name, String dstAddress, String dstPort) {
        this.name = name;
        this.dstPort = dstPort;
        this.dstAddress = dstAddress;
    }

    public Rule(String name, String port) {
        this(name, null, port);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDstAddress() {
        return this.dstAddress;
    }

    public void setDstAddress(String dstAddress) {
        this.dstAddress = dstAddress;
    }

    @Override
    public String getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(String dstPort) {
        this.dstPort = dstPort;
    }

    @Override
    public String getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(String srcPort) {
        this.srcPort = srcPort;
    }

    @Override
    public String getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(String srcAddress) {
        this.srcAddress = srcAddress;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isOmnidirectional() {
        return this.omnidirectional;
    }

    public void setOmnidirectional(boolean omnidirectional) {
        this.omnidirectional = omnidirectional;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public String getExporterFilter() {
        return this.exporterFilter;
    }

    public void setExporterFilter(String exporterFilter) {
        this.exporterFilter = exporterFilter;
    }

    public Group getGroup() {
        return this.group;
    }

    @Override
    public int getGroupPriority() {
        return this.group == null ? 0 : this.group.getPriority();
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("dstAddress", (Object)this.dstAddress).add("dstPort", (Object)this.dstPort).add("srcAddress", (Object)this.srcAddress).add("srcPort", (Object)this.srcPort).add("exporterFilter", (Object)this.exporterFilter).add("protocol", (Object)this.protocol).add("omnidirectional", this.omnidirectional).add("position", this.position).add("group", (Object)this.group).toString();
    }
}

