/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.Objects;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class BridgePort
implements Topology {
    private Integer m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private Integer m_vlan;

    public static BridgePort getFromBridgeForwardingTableEntry(BridgeForwardingTableEntry link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNodeId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getFromBridgeMacLink(BridgeMacLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNode().getId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getFromBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNode().getId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getFromDesignatedBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getDesignatedNode().getId());
        bp.setBridgePort(link.getDesignatedPort());
        bp.setBridgePortIfIndex(link.getDesignatedPortIfIndex());
        bp.setVlan(link.getDesignatedVlan());
        return bp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BridgePort that = (BridgePort)o;
        return Objects.equals(this.m_node, that.m_node) && Objects.equals(this.m_bridgePort, that.m_bridgePort);
    }

    public int hashCode() {
        return Objects.hash(this.m_node, this.m_bridgePort);
    }

    public Integer getNodeId() {
        return this.m_node;
    }

    public void setNodeId(Integer node) {
        this.m_node = node;
    }

    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("nodeid:[");
        strbfr.append(this.getNodeId());
        strbfr.append("], bridgeport:[");
        strbfr.append(this.getBridgePort());
        strbfr.append("], ifindex:[");
        strbfr.append(this.getBridgePortIfIndex());
        strbfr.append("], vlan:[");
        strbfr.append(this.getVlan());
        strbfr.append("]");
        return strbfr.toString();
    }
}

