/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.echo;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.echo.EchoRequest;
import org.opennms.core.rpc.echo.EchoResponse;
import org.opennms.core.rpc.echo.MyEchoException;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;

public class EchoRpcModule
extends AbstractXmlRpcModule<EchoRequest, EchoResponse> {
    public static final EchoRpcModule INSTANCE = new EchoRpcModule();
    public static final String RPC_MODULE_ID = "Echo";
    private static final Supplier<Timer> TIMER_SUPPLIER = Suppliers.memoize(() -> new Timer("EchoRpcModule"));

    public EchoRpcModule() {
        super(EchoRequest.class, EchoResponse.class);
    }

    public void beforeRun() {
    }

    public CompletableFuture<EchoResponse> execute(final EchoRequest request) {
        final CompletableFuture<EchoResponse> future = new CompletableFuture<EchoResponse>();
        if (request.getDelay() != null) {
            ((Timer)TIMER_SUPPLIER.get()).schedule(new TimerTask(){

                @Override
                public void run() {
                    EchoRpcModule.this.processRequest(request, future);
                }
            }, request.getDelay());
        } else {
            this.processRequest(request, future);
        }
        return future;
    }

    public void processRequest(EchoRequest request, CompletableFuture<EchoResponse> future) {
        this.beforeRun();
        if (request.shouldThrow()) {
            future.completeExceptionally(new MyEchoException(request.getMessage()));
        } else {
            EchoResponse response = new EchoResponse();
            response.setId(request.getId());
            response.setMessage(request.getMessage());
            response.setBody(request.getBody());
            future.complete(response);
        }
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public EchoResponse createResponseWithException(Throwable ex) {
        return new EchoResponse(ex);
    }
}

