/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlResourceKey;

@XmlRootElement(name="xml-group")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XmlGroup
implements Serializable,
Comparable<XmlGroup>,
Cloneable {
    private static final long serialVersionUID = 2716588565159391498L;
    @XmlTransient
    private static final XmlObject[] OF_XML_OBJECTS = new XmlObject[0];
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="resource-type", required=true)
    private String m_resourceType;
    @XmlAttribute(name="resource-xpath", required=true)
    private String m_resourceXpath;
    @XmlAttribute(name="key-xpath", required=false)
    private String m_keyXpath;
    @XmlAttribute(name="timestamp-xpath", required=false)
    private String m_timestampXpath;
    @XmlAttribute(name="timestamp-format", required=false)
    private String m_timestampFormat;
    @XmlElement(name="xml-object", required=true)
    private List<XmlObject> m_xmlObjects = new ArrayList<XmlObject>();
    @XmlElement(name="resource-key", required=false)
    private XmlResourceKey m_xmlResourceKey;

    public XmlGroup() {
    }

    public XmlGroup(XmlGroup copy) {
        this.m_name = copy.m_name;
        this.m_resourceType = copy.m_resourceType;
        this.m_resourceXpath = copy.m_resourceXpath;
        this.m_keyXpath = copy.m_keyXpath;
        this.m_timestampXpath = copy.m_timestampXpath;
        this.m_timestampFormat = copy.m_timestampFormat;
        copy.m_xmlObjects.stream().forEach(o -> this.m_xmlObjects.add(o.clone()));
        this.m_xmlResourceKey = copy.m_xmlResourceKey != null ? copy.m_xmlResourceKey.clone() : this.m_xmlResourceKey;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public List<XmlObject> getXmlObjects() {
        return this.m_xmlObjects;
    }

    public void setXmlObjects(List<XmlObject> xmlObjects) {
        this.m_xmlObjects = xmlObjects;
    }

    public void addXmlObject(XmlObject xmlObject) {
        this.m_xmlObjects.add(xmlObject);
    }

    public void removeXmlObject(XmlObject xmlObject) {
        this.m_xmlObjects.remove(xmlObject);
    }

    public void removeObjectByName(String name) {
        for (XmlObject column : this.m_xmlObjects) {
            if (!column.getName().equals(name)) continue;
            this.m_xmlObjects.remove(column);
            return;
        }
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public void setResourceType(String resourceType) {
        this.m_resourceType = resourceType;
    }

    public String getResourceXpath() {
        return this.m_resourceXpath;
    }

    public void setResourceXpath(String resourceXpath) {
        this.m_resourceXpath = resourceXpath;
    }

    public String getKeyXpath() {
        return this.m_keyXpath;
    }

    public void setKeyXpath(String keyXpath) {
        this.m_keyXpath = keyXpath;
    }

    public String getTimestampXpath() {
        return this.m_timestampXpath;
    }

    public void setTimestampXpath(String timestampXpath) {
        this.m_timestampXpath = timestampXpath;
    }

    public String getTimestampFormat() {
        return this.m_timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.m_timestampFormat = timestampFormat;
    }

    public String getIfType() {
        return this.m_resourceType.equals("node") ? "ignore" : "all";
    }

    public XmlResourceKey getXmlResourceKey() {
        return this.m_xmlResourceKey;
    }

    public void setXmlResourceKey(XmlResourceKey xmlResourceKey) {
        this.m_xmlResourceKey = xmlResourceKey;
    }

    public boolean hasMultipleResourceKey() {
        return this.m_xmlResourceKey != null && !this.m_xmlResourceKey.getKeyXpathList().isEmpty();
    }

    @Override
    public int compareTo(XmlGroup obj) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)obj.getName()).append((Object)this.getResourceType(), (Object)obj.getResourceType()).append((Object)this.getResourceXpath(), (Object)obj.getResourceXpath()).append((Object)this.getKeyXpath(), (Object)obj.getKeyXpath()).append((Object[])this.getXmlObjects().toArray(OF_XML_OBJECTS), (Object[])obj.getXmlObjects().toArray(OF_XML_OBJECTS)).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlGroup) {
            XmlGroup other = (XmlGroup)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getResourceType(), (Object)other.getResourceType()).append((Object)this.getResourceXpath(), (Object)other.getResourceXpath()).append((Object)this.getKeyXpath(), (Object)other.getKeyXpath()).append((Object[])this.getXmlObjects().toArray(OF_XML_OBJECTS), (Object[])other.getXmlObjects().toArray(OF_XML_OBJECTS)).isEquals();
        }
        return false;
    }

    public XmlGroup clone() {
        return new XmlGroup(this);
    }
}

