/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.ClassificationRuleProvider;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.classifier.Classifier;
import org.opennms.netmgt.flows.classification.internal.classifier.CombinedClassifier;
import org.opennms.netmgt.flows.classification.internal.value.PortValue;
import org.opennms.netmgt.flows.classification.persistence.api.DefaultRuleDefinition;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RuleDefinition;
import org.opennms.netmgt.flows.classification.persistence.api.RulePriorityComparator;

public class DefaultClassificationEngine
implements ClassificationEngine {
    private final List<List<Classifier>> classifierPortList = new ArrayList<List<Classifier>>(65536);
    private final Comparator<RuleDefinition> ruleComparator = new RulePriorityComparator();
    private final ClassificationRuleProvider ruleProvider;
    private final FilterService filterService;

    public DefaultClassificationEngine(ClassificationRuleProvider ruleProvider, FilterService filterService) {
        this(ruleProvider, filterService, true);
    }

    public DefaultClassificationEngine(ClassificationRuleProvider ruleProvider, FilterService filterService, boolean initialize) {
        this.ruleProvider = Objects.requireNonNull(ruleProvider);
        this.filterService = Objects.requireNonNull(filterService);
        if (initialize) {
            this.reload();
        }
    }

    public void reload() {
        int i;
        this.classifierPortList.clear();
        List rules = this.ruleProvider.getRules();
        ArrayList rulePortList = new ArrayList(65536);
        ArrayList<Rule> anyPortRules = new ArrayList<Rule>();
        for (int i2 = 0; i2 < 65536; ++i2) {
            rulePortList.add(new ArrayList());
            this.classifierPortList.add(new ArrayList());
        }
        for (Rule rule2 : rules) {
            if (rule2.hasSrcPortDefinition() && rule2.hasDstPortDefinition()) {
                for (Integer n : new PortValue(rule2.getDstPort()).getPorts()) {
                    List portRules = (List)rulePortList.get(n);
                    if (portRules.contains(rule2)) continue;
                    portRules.add(rule2);
                }
                continue;
            }
            if (rule2.hasSrcPortDefinition() || rule2.hasDstPortDefinition()) {
                PortValue portValue = new PortValue(rule2.hasDstPortDefinition() ? rule2.getDstPort() : rule2.getSrcPort());
                for (Integer eachPort2 : portValue.getPorts()) {
                    ((List)rulePortList.get(eachPort2)).add(rule2);
                }
                continue;
            }
            if (rule2.hasDstPortDefinition() || rule2.hasSrcPortDefinition()) continue;
            anyPortRules.add(rule2);
        }
        for (List list : rulePortList) {
            list.addAll(anyPortRules);
        }
        for (i = 0; i < rulePortList.size(); ++i) {
            List list = (List)rulePortList.get(i);
            Collections.sort(list, this.ruleComparator);
        }
        i = 0;
        while (i < rulePortList.size()) {
            int n = i++;
            List portRules = (List)rulePortList.get(n);
            List list = portRules.stream().map(rule -> {
                DefaultRuleDefinition portRule = new DefaultRuleDefinition();
                portRule.setName(rule.getName());
                portRule.setProtocol(rule.getProtocol());
                portRule.setSrcAddress(rule.getSrcAddress());
                portRule.setDstAddress(rule.getDstAddress());
                portRule.setExporterFilter(rule.getExporterFilter());
                portRule.setGroupPriority(rule.getGroupPriority());
                if (rule.hasDstPortDefinition() && rule.hasSrcPortDefinition()) {
                    portRule.setSrcPort(rule.getSrcPort());
                } else {
                    if (rule.hasDstPortDefinition()) {
                        portRule.setDstPort(Integer.toString(port));
                    }
                    if (rule.hasSrcPortDefinition()) {
                        portRule.setSrcPort(Integer.toString(port));
                    }
                }
                return new CombinedClassifier((RuleDefinition)portRule, this.filterService);
            }).collect(Collectors.toList());
            this.classifierPortList.set(n, list);
        }
    }

    public String classify(ClassificationRequest classificationRequest) {
        Collection<Classifier> filteredClassifiers = this.getClassifiers(classificationRequest);
        Optional<String> first = filteredClassifiers.stream().map(classifier -> classifier.classify(classificationRequest)).filter(classifier -> classifier != null).findFirst();
        return first.orElse(null);
    }

    private Collection<Classifier> getClassifiers(ClassificationRequest request) {
        List<Classifier> srcPortClassifiers = this.classifierPortList.get(request.getSrcPort());
        List<Classifier> dstPortClassifiers = this.classifierPortList.get(request.getDstPort());
        if (srcPortClassifiers.isEmpty()) {
            return dstPortClassifiers;
        }
        if (dstPortClassifiers.isEmpty()) {
            return srcPortClassifiers;
        }
        if (Objects.equals(srcPortClassifiers, dstPortClassifiers)) {
            return dstPortClassifiers;
        }
        ArrayList<Classifier> classifiers = new ArrayList<Classifier>();
        classifiers.addAll(srcPortClassifiers);
        for (Classifier c : dstPortClassifiers) {
            if (classifiers.contains(c)) continue;
            classifiers.add(c);
        }
        Collections.sort(classifiers);
        return classifiers;
    }
}

