/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy;

import java.util.Objects;
import org.opennms.netmgt.snmp.SnmpObjId;

public class WalkRequest {
    private final SnmpObjId baseOid;
    private int maxRepetitions = 1;
    private SnmpObjId instance = null;
    private String correlationId = null;

    public WalkRequest(SnmpObjId baseOid) {
        this.baseOid = Objects.requireNonNull(baseOid);
    }

    public SnmpObjId getBaseOid() {
        return this.baseOid;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public void setInstance(SnmpObjId instance) {
        this.instance = instance;
    }

    public SnmpObjId getInstance() {
        return this.instance;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String toString() {
        return String.format("WalkRequest[baseOid=%s, correlationId=%s, maxRepetitions=%d, instance=%s]", this.baseOid, this.correlationId, this.maxRepetitions, this.instance);
    }

    public int hashCode() {
        return Objects.hash(this.baseOid, this.correlationId, this.maxRepetitions, this.instance);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WalkRequest other = (WalkRequest)obj;
        return Objects.equals(this.baseOid, other.baseOid) && Objects.equals(this.correlationId, other.correlationId) && Objects.equals(this.maxRepetitions, other.maxRepetitions) && Objects.equals(this.instance, other.instance);
    }
}

