/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapIdentity {
    private static final transient Logger LOG = LoggerFactory.getLogger(TrapIdentity.class);
    private int m_generic;
    private int m_specific;
    private String m_enterpriseId;
    private static final List<SnmpObjId> GENERIC_TRAPS = new ArrayList<SnmpObjId>();
    private static final char DOT_CHAR = '.';
    private static final String SNMP_TRAP_ENTERPRISE_ID = ".1.3.6.1.6.3.1.1.4.3.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";

    public TrapIdentity(SnmpObjId snmpTrapOid, SnmpObjId lastVarBindOid, SnmpValue lastVarBindValue) {
        String snmpTrapOidValue = snmpTrapOid.toString();
        LOG.debug("snmpTrapOID: {}", (Object)snmpTrapOidValue);
        int lastIndex = snmpTrapOidValue.lastIndexOf(46);
        String lastSubIdStr = snmpTrapOidValue.substring(lastIndex + 1);
        int lastSubId = -1;
        try {
            lastSubId = Integer.parseInt(lastSubIdStr);
        }
        catch (NumberFormatException nfe) {
            lastSubId = -1;
        }
        if (GENERIC_TRAPS.contains(snmpTrapOid)) {
            this.setGeneric(lastSubId - 1);
            this.setSpecific(0);
            String varBindName = lastVarBindOid.toString();
            if (varBindName.equals(SNMP_TRAP_ENTERPRISE_ID)) {
                this.setEnterpriseId(lastVarBindValue.toString());
            } else {
                this.setEnterpriseId(".1.3.6.1.6.3.1.1.5." + snmpTrapOidValue.charAt(snmpTrapOidValue.length() - 1));
            }
        } else {
            this.setGeneric(6);
            this.setSpecific(lastSubId);
            int nextToLastIndex = snmpTrapOidValue.lastIndexOf(46, lastIndex - 1);
            String nextToLastSubIdStr = snmpTrapOidValue.substring(nextToLastIndex + 1, lastIndex);
            if (nextToLastSubIdStr.equals("0")) {
                this.setEnterpriseId(snmpTrapOidValue.substring(0, nextToLastIndex));
            } else {
                this.setEnterpriseId(snmpTrapOidValue.substring(0, lastIndex));
            }
        }
    }

    public TrapIdentity(SnmpObjId entId, int generic, int specific) {
        this.m_enterpriseId = entId.toString();
        this.m_generic = generic;
        this.m_specific = specific;
    }

    public int getGeneric() {
        return this.m_generic;
    }

    private void setGeneric(int generic) {
        this.m_generic = generic;
    }

    public int getSpecific() {
        return this.m_specific;
    }

    private void setSpecific(int specific) {
        this.m_specific = specific;
    }

    public String getEnterpriseId() {
        return this.m_enterpriseId;
    }

    private void setEnterpriseId(String enterpriseId) {
        this.m_enterpriseId = enterpriseId;
    }

    public String toString() {
        return "[Generic=" + this.getGeneric() + ", Specific=" + this.getSpecific() + ", EnterpriseId=" + this.getEnterpriseId() + "]";
    }

    static {
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.1"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.2"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.3"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.4"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.5"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.6"));
    }
}

