/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.InetAddrUtils;

public final class SnmpAgentAddress {
    private final InetAddress m_address;
    private final Integer m_port;

    public SnmpAgentAddress(InetAddress agentAddress, Integer agentPort) {
        if (agentAddress == null) {
            throw new NullPointerException("agentAddress cannot be null");
        }
        if (agentPort == null) {
            throw new NullPointerException("agentPort cannot be null");
        }
        this.m_address = agentAddress;
        this.m_port = agentPort;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public Integer getPort() {
        return this.m_port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnmpAgentAddress)) {
            return false;
        }
        SnmpAgentAddress that = (SnmpAgentAddress)obj;
        return this.m_address.equals(that.m_address) && this.m_port.equals(that.m_port);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.m_address.hashCode();
        hashCode = hashCode * 37 + this.m_port.hashCode();
        return hashCode;
    }

    public String toString() {
        return InetAddrUtils.str(this.m_address) + ":" + this.m_port;
    }
}

