/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.jms;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcServerProcessor;
import org.opennms.core.rpc.camel.CamelRpcServerRouteManager;
import org.opennms.distributed.core.api.MinionIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsRpcServerRouteManager
extends CamelRpcServerRouteManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerRouteManager.class);

    public JmsRpcServerRouteManager(CamelContext context, MinionIdentity identity) {
        super(context, identity);
    }

    public RouteBuilder getRouteBuilder(CamelContext context, MinionIdentity identity, RpcModule<RpcRequest, RpcResponse> module) {
        return new DynamicRpcRouteBuilder(context, identity, module);
    }

    static String getJmsSelector(String systemId) {
        if (systemId == null) {
            return String.format("%s IS NULL", "SystemId");
        }
        return String.format("%s='%s' OR %s IS NULL", "SystemId", systemId.replace("'", "\\'"), "SystemId");
    }

    private static final class DynamicRpcRouteBuilder
    extends RouteBuilder {
        private final MinionIdentity identity;
        private final RpcModule<RpcRequest, RpcResponse> module;
        private final JmsQueueNameFactory queueNameFactory;

        private DynamicRpcRouteBuilder(CamelContext context, MinionIdentity identity, RpcModule<RpcRequest, RpcResponse> module) {
            super(context);
            this.identity = identity;
            this.module = module;
            this.queueNameFactory = new JmsQueueNameFactory("RPC", module.getId(), identity.getLocation());
        }

        public String getQueueName() {
            return this.queueNameFactory.getName();
        }

        public void configure() throws Exception {
            JmsEndpoint endpoint = (JmsEndpoint)this.getContext().getEndpoint(String.format("queuingservice:%s?asyncConsumer=true", this.queueNameFactory.getName()), JmsEndpoint.class);
            String selector = JmsRpcServerRouteManager.getJmsSelector(this.identity.getId());
            LOG.trace("Using JMS selector: {} for module: {} on: {}", new Object[]{selector, this.module, this.identity});
            endpoint.setSelector(selector);
            ((RouteDefinition)((RouteDefinition)this.from((Endpoint)endpoint).setExchangePattern(ExchangePattern.InOut)).process((Processor)new CamelRpcServerProcessor(this.module))).routeId(CamelRpcServerRouteManager.getRouteId(this.module));
        }
    }
}

