/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.URISupport;

public class EndpointStatisticCommand
extends AbstractCamelCommand {
    private static final String CONTEXT_COLUMN_LABEL = "Context";
    private static final String URI_COLUMN_LABEL = "Uri";
    private static final String ROUTE_COLUMN_LABEL = "Route Id";
    private static final String DIRECTION_COLUMN_LABEL = "Direction";
    private static final String STATIC_COLUMN_LABEL = "Static";
    private static final String DYNAMIC_COLUMN_LABEL = "Dynamic";
    private static final String HITS_COLUMN_LABEL = "Total #";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    String context;
    boolean decode = true;
    private String[] filter;

    public EndpointStatisticCommand(String context, boolean decode, String[] filter) {
        this.context = context;
        this.decode = decode;
        this.filter = filter;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> contexts = camelController.getCamelContexts(this.context);
        boolean header = false;
        LinkedHashMap<String, List<Map<String, String>>> allEndpoints = new LinkedHashMap<String, List<Map<String, String>>>();
        for (Map<String, String> context : contexts) {
            String contextName = context.get("name");
            List<Map<String, String>> endpoints = camelController.getEndpointRuntimeStatistics(contextName);
            allEndpoints.put(contextName, endpoints);
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(allEndpoints);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        for (Map.Entry entry : allEndpoints.entrySet()) {
            String contextName = (String)entry.getKey();
            for (Map row : (List)entry.getValue()) {
                if (!header) {
                    out.println(String.format(headerFormat, CONTEXT_COLUMN_LABEL, URI_COLUMN_LABEL, ROUTE_COLUMN_LABEL, DIRECTION_COLUMN_LABEL, STATIC_COLUMN_LABEL, DYNAMIC_COLUMN_LABEL, HITS_COLUMN_LABEL));
                    out.println(String.format(headerFormat, "-------", "---", "--------", "---------", "------", "-------", "-------"));
                    header = true;
                }
                String uri = (String)row.get("uri");
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                uri = URISupport.sanitizeUri((String)uri);
                String routeId = (String)row.get("routeId");
                String direction = (String)row.get("direction");
                String isStatic = (String)row.get("static");
                String isDynamic = (String)row.get("dynamic");
                String hits = (String)row.get("hits");
                if (!this.isValidRow(direction, isStatic, isDynamic)) continue;
                out.println(String.format(rowFormat, contextName, uri, routeId, direction, isStatic, isDynamic, hits));
            }
        }
        return null;
    }

    protected boolean isValidRow(String direction, String isStatic, String isDynamic) {
        if (this.filter == null || this.filter.length == 0) {
            return true;
        }
        boolean answer = false;
        for (String f : this.filter) {
            if ("in".equals(f)) {
                answer = "in".equals(direction);
            } else if ("out".equals(f)) {
                answer = "out".equals(direction);
            } else if ("static".equals(f)) {
                answer = "true".equals(isStatic);
            } else if ("dynamic".equals(f)) {
                answer = "true".equals(isDynamic);
            }
            if (answer) continue;
            return false;
        }
        return answer;
    }

    private Map<String, Integer> computeColumnWidths(Map<String, List<Map<String, String>>> allEndpoints) throws Exception {
        if (allEndpoints == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<Endpoint>");
        }
        int maxContextLen = 0;
        int maxUriLen = 0;
        int maxRouteIdLen = 0;
        int maxDirectionLen = 0;
        int maxStaticLen = 0;
        int maxDynamicLen = 0;
        int maxHitsLen = 0;
        for (Map.Entry<String, List<Map<String, String>>> entry : allEndpoints.entrySet()) {
            String contextName = entry.getKey();
            for (Map<String, String> row : entry.getValue()) {
                maxContextLen = Math.max(maxContextLen, contextName == null ? 0 : contextName.length());
                String uri = row.get("uri");
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                maxUriLen = Math.max(maxUriLen, (uri = URISupport.sanitizeUri((String)uri)) == null ? 0 : uri.length());
                String routeId = row.get("routeId");
                maxRouteIdLen = Math.max(maxRouteIdLen, routeId == null ? 0 : routeId.length());
                String direction = row.get("direction");
                maxDirectionLen = Math.max(maxDirectionLen, direction == null ? 0 : direction.length());
                String isStatic = row.get("static");
                maxStaticLen = Math.max(maxStaticLen, isStatic == null ? 0 : isStatic.length());
                String isDynamic = row.get("dynamic");
                maxDynamicLen = Math.max(maxDynamicLen, isDynamic == null ? 0 : isDynamic.length());
                String hits = row.get("hits");
                maxHitsLen = Math.max(maxHitsLen, hits == null ? 0 : hits.length());
            }
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(CONTEXT_COLUMN_LABEL, maxContextLen);
        retval.put(URI_COLUMN_LABEL, maxUriLen);
        retval.put(ROUTE_COLUMN_LABEL, maxRouteIdLen);
        retval.put(DIRECTION_COLUMN_LABEL, maxDirectionLen);
        retval.put(STATIC_COLUMN_LABEL, maxStaticLen);
        retval.put(DYNAMIC_COLUMN_LABEL, maxDynamicLen);
        retval.put(HITS_COLUMN_LABEL, maxHitsLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int contextLen = Math.min(columnWidths.get(CONTEXT_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        contextLen = Math.max(12, contextLen);
        int uriLen = Math.min(columnWidths.get(URI_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        uriLen = Math.max(12, uriLen);
        int routeIdLen = Math.min(columnWidths.get(ROUTE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        routeIdLen = Math.max(12, routeIdLen);
        int directionLen = Math.min(columnWidths.get(DIRECTION_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        directionLen = Math.max(12, directionLen);
        int staticLen = Math.min(columnWidths.get(STATIC_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        staticLen = Math.max(12, staticLen);
        int dynamicLen = Math.min(columnWidths.get(DYNAMIC_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        dynamicLen = Math.max(12, dynamicLen);
        int totalLen = Math.min(columnWidths.get(HITS_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        totalLen = Math.max(12, totalLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(contextLen).append('.').append(contextLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(uriLen).append('.').append(uriLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(routeIdLen).append('.').append(routeIdLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(directionLen).append('.').append(directionLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(staticLen).append('.').append(staticLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(dynamicLen).append('.').append(dynamicLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%").append(totalLen).append('.').append(totalLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        return 120;
    }
}

