/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wmi.agent.Range;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="wmi-config.xsd")
public class Definition
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="retry")
    private Integer m_retry;
    @XmlAttribute(name="timeout")
    private Integer m_timeout;
    @XmlAttribute(name="username")
    private String m_username;
    @XmlAttribute(name="domain")
    private String m_domain;
    @XmlAttribute(name="password")
    private String m_password;
    @XmlElement(name="range")
    private List<Range> m_ranges = new ArrayList<Range>();
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="ip-match")
    private List<String> m_ipMatches = new ArrayList<String>();

    public Integer getRetry() {
        return this.m_retry != null ? this.m_retry : 1;
    }

    public void setRetry(Integer retry) {
        this.m_retry = retry;
    }

    public Integer getTimeout() {
        return this.m_timeout != null ? this.m_timeout : 3000;
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.m_username);
    }

    public void setUsername(String username) {
        this.m_username = ConfigUtils.normalizeString(username);
    }

    public Optional<String> getDomain() {
        return Optional.ofNullable(this.m_domain);
    }

    public void setDomain(String domain) {
        this.m_domain = ConfigUtils.normalizeString(domain);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = ConfigUtils.normalizeString(password);
    }

    public List<Range> getRanges() {
        return this.m_ranges;
    }

    public void setRanges(List<Range> ranges) {
        if (ranges == this.m_ranges) {
            return;
        }
        this.m_ranges.clear();
        if (ranges != null) {
            this.m_ranges.addAll(ranges);
        }
    }

    public void addRange(Range range) {
        this.m_ranges.add(range);
    }

    public boolean removeRange(Range range) {
        return this.m_ranges.remove(range);
    }

    public List<String> getSpecifics() {
        return this.m_specifics;
    }

    public void setSpecifics(List<String> specifics) {
        if (specifics == this.m_specifics) {
            return;
        }
        this.m_specifics.clear();
        if (specifics != null) {
            this.m_specifics.addAll(specifics);
        }
    }

    public void addSpecific(String specific) {
        this.m_specifics.add(specific);
    }

    public boolean removeSpecific(String specific) {
        return this.m_specifics.remove(specific);
    }

    public List<String> getIpMatches() {
        return this.m_ipMatches;
    }

    public void setIpMatches(List<String> ipMatches) {
        if (ipMatches == this.m_ipMatches) {
            return;
        }
        this.m_ipMatches.clear();
        if (ipMatches != null) {
            this.m_ipMatches.addAll(ipMatches);
        }
    }

    public void addIpMatch(String ipMatch) {
        this.m_ipMatches.add(ipMatch);
    }

    public boolean removeIpMatch(String ipMatch) {
        return this.m_ipMatches.remove(ipMatch);
    }

    public int hashCode() {
        return Objects.hash(this.m_retry, this.m_timeout, this.m_username, this.m_domain, this.m_password, this.m_ranges, this.m_specifics, this.m_ipMatches);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Definition) {
            Definition that = (Definition)obj;
            return Objects.equals(this.m_retry, that.m_retry) && Objects.equals(this.m_timeout, that.m_timeout) && Objects.equals(this.m_username, that.m_username) && Objects.equals(this.m_domain, that.m_domain) && Objects.equals(this.m_password, that.m_password) && Objects.equals(this.m_ranges, that.m_ranges) && Objects.equals(this.m_specifics, that.m_specifics) && Objects.equals(this.m_ipMatches, that.m_ipMatches);
        }
        return false;
    }
}

