/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rancid.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.rancid.adapter.Package;
import org.opennms.netmgt.config.rancid.adapter.Schedule;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="policy-manage")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="rancid-adapter-configuration.xsd")
public class PolicyManage
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="delay")
    private Long m_delay;
    @XmlAttribute(name="retries")
    private Integer m_retries;
    @XmlAttribute(name="useCategories")
    private Boolean m_useCategories;
    @XmlAttribute(name="default-type")
    private String m_defaultType;
    @XmlElement(name="package", required=true)
    private Package m_package;
    @XmlElement(name="schedule")
    private List<Schedule> m_schedules = new ArrayList<Schedule>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<Long> getDelay() {
        return Optional.ofNullable(this.m_delay);
    }

    public void setDelay(Long delay) {
        this.m_delay = delay;
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.m_retries);
    }

    public void setRetries(Integer retries) {
        this.m_retries = retries;
    }

    public Optional<Boolean> getUseCategories() {
        return Optional.ofNullable(this.m_useCategories);
    }

    public void setUseCategories(Boolean useCategories) {
        this.m_useCategories = useCategories;
    }

    public Optional<String> getDefaultType() {
        return Optional.ofNullable(this.m_defaultType);
    }

    public void setDefaultType(String defaultType) {
        this.m_defaultType = ConfigUtils.normalizeString(defaultType);
    }

    public Package getPackage() {
        return this.m_package;
    }

    public void setPackage(Package p) {
        this.m_package = ConfigUtils.assertNotNull(p, "package");
    }

    public List<Schedule> getSchedules() {
        return this.m_schedules;
    }

    public void setSchedules(List<Schedule> schedules) {
        if (schedules == this.m_schedules) {
            return;
        }
        this.m_schedules.clear();
        if (schedules != null) {
            this.m_schedules.addAll(schedules);
        }
    }

    public void addSchedule(Schedule schedule) {
        this.m_schedules.add(schedule);
    }

    public boolean removeSchedule(Schedule schedule) {
        return this.m_schedules.remove(schedule);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_delay, this.m_retries, this.m_useCategories, this.m_defaultType, this.m_package, this.m_schedules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PolicyManage) {
            PolicyManage that = (PolicyManage)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_delay, that.m_delay) && Objects.equals(this.m_retries, that.m_retries) && Objects.equals(this.m_useCategories, that.m_useCategories) && Objects.equals(this.m_defaultType, that.m_defaultType) && Objects.equals(this.m_package, that.m_package) && Objects.equals(this.m_schedules, that.m_schedules);
        }
        return false;
    }
}

