/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.inject.Inject;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleProcessor;
import org.opennms.newts.cassandra.CassandraException;
import org.opennms.newts.cassandra.search.CassandraIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraIndexerSampleProcessor
implements SampleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraIndexerSampleProcessor.class);
    private final CassandraIndexer m_indexer;

    @Inject
    public CassandraIndexerSampleProcessor(CassandraIndexer indexer) {
        this.m_indexer = (CassandraIndexer)Preconditions.checkNotNull((Object)indexer, (Object)"indexer argument");
    }

    public void submit(Collection<Sample> samples) {
        try {
            this.m_indexer.update(samples);
        }
        catch (CassandraException e) {
            LOG.error("failed to index samples", (Throwable)e);
        }
    }
}

