/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import java.util.Dictionary;
import org.opennms.core.ipc.sink.api.OffHeapQueue;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffHeapServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OffHeapServiceLoader.class);
    private static BundleContext context;
    private static Boolean offHeapEnabled;
    private static OffHeapQueue offHeapQueue;
    public static final String OFFHEAP_CONFIG = "org.opennms.core.ipc.sink.offheap";
    public static final String ENABLE_OFFHEAP = "enableOffHeap";

    public BundleContext getBundleContext() {
        return context;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        context = bundleContext;
    }

    public static boolean isOffHeapEnabled() {
        if (offHeapEnabled != null) {
            return offHeapEnabled;
        }
        if (context != null) {
            try {
                ConfigurationAdmin configAdmin = (ConfigurationAdmin)context.getService(context.getServiceReference(ConfigurationAdmin.class));
                Dictionary properties = configAdmin.getConfiguration(OFFHEAP_CONFIG).getProperties();
                if (properties != null && properties.get(ENABLE_OFFHEAP) != null && properties.get(ENABLE_OFFHEAP) instanceof String) {
                    offHeapEnabled = Boolean.parseBoolean((String)properties.get(ENABLE_OFFHEAP));
                    return offHeapEnabled;
                }
            }
            catch (Exception e) {
                LOG.error("Exception while retrieving Configuration Admin from registry", (Throwable)e);
            }
        }
        return false;
    }

    public static OffHeapQueue getOffHeapQueue() {
        if (offHeapQueue != null) {
            return offHeapQueue;
        }
        if (context != null) {
            try {
                offHeapQueue = (OffHeapQueue)context.getService(context.getServiceReference(OffHeapQueue.class));
                return offHeapQueue;
            }
            catch (Exception e) {
                LOG.error("Exception while retrieving OffHeapQueue Service from registry", (Throwable)e);
            }
        }
        return null;
    }

    protected static void setOffHeapQueue(OffHeapQueue queue) {
        offHeapQueue = queue;
    }

    protected static void setOffHeapEnabled(boolean enabled) {
        offHeapEnabled = enabled;
    }
}

