/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Comparator;
import org.opennms.core.utils.ByteArrayComparator;

public class InetAddressComparator
implements Comparator<InetAddress> {
    @Override
    public int compare(InetAddress addr1, InetAddress addr2) {
        if (addr1 == null) {
            if (addr2 == null) {
                return 0;
            }
            return -1;
        }
        if (addr2 == null) {
            return 1;
        }
        if (addr1 instanceof Inet4Address) {
            if (addr2 instanceof Inet4Address) {
                return new ByteArrayComparator().compare(addr1.getAddress(), addr2.getAddress());
            }
            return -1;
        }
        if (addr2 instanceof Inet4Address) {
            return 1;
        }
        int scopeComparison = Integer.valueOf(((Inet6Address)addr1).getScopeId()).compareTo(((Inet6Address)addr2).getScopeId());
        if (scopeComparison == 0) {
            return new ByteArrayComparator().compare(addr1.getAddress(), addr2.getAddress());
        }
        return scopeComparison;
    }
}

