/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpVarBind
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 2328987288282447623L;
    private SnmpObjectId m_name;
    private SnmpSyntax m_value;
    public static final byte ASNTYPE = 48;

    public SnmpVarBind() {
        this.m_name = new SnmpObjectId();
        this.m_value = new SnmpNull();
    }

    public SnmpVarBind(SnmpObjectId name) {
        this.m_name = (SnmpObjectId)name.duplicate();
        this.m_value = new SnmpNull();
    }

    public SnmpVarBind(SnmpObjectId name, SnmpSyntax value) {
        this.m_name = (SnmpObjectId)name.duplicate();
        this.m_value = value.duplicate();
    }

    public SnmpVarBind(String name) {
        this.m_name = new SnmpObjectId(name);
        this.m_value = new SnmpNull();
    }

    public SnmpVarBind(String name, SnmpSyntax value) {
        this.m_name = new SnmpObjectId(name);
        this.m_value = value.duplicate();
    }

    public SnmpVarBind(SnmpVarBind second) {
        this.m_name = (SnmpObjectId)second.m_name.duplicate();
        this.m_value = second.m_value.duplicate();
    }

    public SnmpObjectId getName() {
        return this.m_name;
    }

    public void setName(SnmpObjectId name) {
        this.m_name = (SnmpObjectId)name.duplicate();
    }

    public void setName(String name) {
        this.m_name = new SnmpObjectId(name);
    }

    public SnmpSyntax getValue() {
        return this.m_value;
    }

    public void setValue(SnmpSyntax value) {
        this.m_value = value.duplicate();
    }

    @Override
    public byte typeId() {
        return 48;
    }

    @Override
    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        int begin = offset;
        offset = this.m_name.encodeASN(buf, offset, encoder);
        int pivot = offset = this.m_value.encodeASN(buf, offset, encoder);
        int end = encoder.buildHeader(buf, offset, this.typeId(), pivot - begin);
        SnmpUtil.rotate(buf, begin, pivot, end);
        return end;
    }

    @Override
    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseHeader(buf, offset);
        offset = (Integer)rVals[0];
        byte asnType = (Byte)rVals[1];
        int asnLength = (Integer)rVals[2];
        if (buf.length - offset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnType != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        offset = this.m_name.decodeASN(buf, offset, encoder);
        this.m_value = SnmpUtil.getSyntaxObject(buf[offset]);
        if (this.m_value == null) {
            throw new AsnDecodingException("Unknown ASN.1 type");
        }
        offset = this.m_value.decodeASN(buf, offset, encoder);
        return offset;
    }

    @Override
    public SnmpVarBind duplicate() {
        return new SnmpVarBind(this);
    }

    public Object clone() {
        return new SnmpVarBind(this);
    }

    public String toString() {
        return this.m_name.toString() + " = " + this.m_value.toString();
    }
}

