/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import org.opennms.protocols.snmp.SnmpBadConversionException;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;

public class SnmpIPAddress
extends SnmpOctetString {
    static final long serialVersionUID = -4375760318106654741L;
    public static final byte ASNTYPE = 64;

    public SnmpIPAddress() {
        byte[] tmp = new byte[]{0, 0, 0, 0};
        super.assumeString(tmp);
    }

    public SnmpIPAddress(byte[] data) {
        super(data);
        if (data.length < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (data.length > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
    }

    public SnmpIPAddress(SnmpIPAddress second) {
        super(second);
    }

    public SnmpIPAddress(SnmpOctetString second) {
        super(second);
        if (this.getLength() < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (this.getLength() > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
    }

    public SnmpIPAddress(InetAddress inetAddr) {
        this(inetAddr.getAddress());
    }

    public SnmpIPAddress(String inetAddr) throws SnmpBadConversionException {
        try {
            byte[] data = InetAddress.getByName(inetAddr).getAddress();
            super.assumeString(data);
        }
        catch (UnknownHostException uhE) {
            throw new SnmpBadConversionException(uhE);
        }
    }

    @Override
    public byte typeId() {
        return 64;
    }

    @Override
    public SnmpSyntax duplicate() {
        return new SnmpIPAddress(this);
    }

    @Override
    public Object clone() {
        return new SnmpIPAddress(this);
    }

    @Override
    public void setString(byte[] data) {
        if (data == null || data.length < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (data.length > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
        super.setString(data);
    }

    @Override
    public void setString(String data) {
        byte[] bdata;
        byte[] byArray = bdata = data == null ? null : data.getBytes();
        if (bdata == null || bdata.length < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (bdata.length > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
        super.assumeString(bdata);
    }

    @Override
    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseString(buf, offset);
        if (((Byte)rVals[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        byte[] data = (byte[])rVals[2];
        if (data.length < 4) {
            throw new AsnDecodingException("Buffer Underflow Exception, length = " + data.length);
        }
        if (data.length > 4) {
            throw new AsnDecodingException("Buffer Overflow Exception, length = " + data.length);
        }
        super.assumeString(data);
        return (Integer)rVals[0];
    }

    public InetAddress convertToIpAddress() {
        byte[] data = this.getString();
        byte[] addr = new byte[]{data[0], data[1], data[2], data[3]};
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to convert " + this + " to an InetAddress", e);
        }
    }

    @Override
    public String toString() {
        byte[] data = this.getString();
        StringBuilder buf = new StringBuilder();
        buf.append(data[0] < 0 ? 256 + data[0] : data[0]).append('.');
        buf.append(data[1] < 0 ? 256 + data[1] : data[1]).append('.');
        buf.append(data[2] < 0 ? 256 + data[2] : data[2]).append('.');
        buf.append(data[3] < 0 ? 256 + data[3] : data[3]);
        return buf.toString();
    }

    public static InetAddress toInetAddress(SnmpIPAddress val) {
        return val == null ? null : val.convertToIpAddress();
    }
}

