/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.ClassInspector;
import com.atomikos.beans.MemberFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MemberChooser {
    Class clazz_;
    ClassInspector inspector_;
    JFrame parent_;
    ResourceBundle messages_;

    public MemberChooser(JFrame parent, Class clazz) {
        this.clazz_ = clazz;
        this.parent_ = parent;
        this.inspector_ = new ClassInspector(clazz);
        this.messages_ = ResourceBundle.getBundle("com.atomikos.beans.MemberChooserResourceBundle");
    }

    public void setMemberFilter(MemberFilter filter) {
        this.inspector_.setMemberFilter(filter);
    }

    public MemberFilter getMemberFilter() {
        return this.inspector_.getMemberFilter();
    }

    public Method showMethodsDialog(Method selectedMethod) {
        Object[] methods = this.inspector_.getMethods();
        Method ret = (Method)JOptionPane.showInputDialog(this.parent_, this.messages_.getString("methodsDialogTitle"), this.messages_.getString("methodsDialogMessage"), 3, null, methods, selectedMethod);
        return ret;
    }

    public Field showFieldsDialog(Method selectedField) {
        Object[] fields = this.inspector_.getFields();
        Field ret = (Field)JOptionPane.showInputDialog(this.parent_, this.messages_.getString("fieldsDialogTitle"), this.messages_.getString("fieldsDialogMessage"), 3, null, fields, selectedField);
        return ret;
    }

    public Constructor showConstructorsDialog(Constructor selectedConstructor) {
        Object[] methods = this.inspector_.getConstructors();
        Constructor ret = (Constructor)JOptionPane.showInputDialog(this.parent_, this.messages_.getString("constructorsDialogTitle"), this.messages_.getString("constructorsDialogMessage"), 3, null, methods, selectedConstructor);
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Constructor c;
        Field f;
        if (args.length == 0) {
            throw new Exception("Missing arg: class name");
        }
        String className = args[0];
        Class<?> clazz = Class.forName(className);
        MemberChooser chooser = new MemberChooser(null, clazz);
        Method m = chooser.showMethodsDialog(null);
        if (m != null) {
            System.out.println(m.toString());
        }
        if ((f = chooser.showFieldsDialog(null)) != null) {
            System.out.println(f.toString());
        }
        if ((c = chooser.showConstructorsDialog(null)) != null) {
            System.out.println(c.toString());
        }
    }
}

