/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.InetAddressUtils;

@XmlRootElement(name="minion-dto")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MinionDTO {
    public static final String SYSTEM_ID = "systemId";
    public static final String LOCATION = "location";
    public static final String SOURCE_ADDRESS = "sourceAddress";
    public static final String SOURCE_PORT = "sourcePort";
    @XmlElementWrapper(name="headers")
    private final Map<String, String> m_headers = Collections.synchronizedMap(new TreeMap());
    @XmlElement(name="body")
    private byte[] m_body;

    public int hashCode() {
        return Objects.hash(this.m_headers, this.m_body);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MinionDTO other = (MinionDTO)obj;
        return Objects.equals(this.m_headers, other.m_headers) && Arrays.equals(this.m_body, other.m_body);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.m_headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeaders(Map<String, String> newHeaders) {
        Map<String, String> map = this.m_headers;
        synchronized (map) {
            this.m_headers.clear();
            this.m_headers.putAll(newHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putHeader(String key, String value) {
        Map<String, String> map = this.m_headers;
        synchronized (map) {
            this.m_headers.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String key) {
        Map<String, String> map = this.m_headers;
        synchronized (map) {
            return this.m_headers.get(key);
        }
    }

    public byte[] getBody() {
        return this.m_body;
    }

    public void setBody(byte[] m_body) {
        this.m_body = m_body;
    }

    public final void setSystemId(String m_systemId) {
        this.putHeader(SYSTEM_ID, m_systemId);
    }

    public final void setLocation(String m_location) {
        this.putHeader(LOCATION, m_location);
    }

    public final void setSourceAddress(InetAddress m_sourceAddress) {
        this.putHeader(SOURCE_ADDRESS, InetAddressUtils.str((InetAddress)m_sourceAddress));
    }

    public final void setSourcePort(int m_sourceport) {
        this.putHeader(SOURCE_PORT, Integer.toString(m_sourceport));
    }
}

