/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.sentinel;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.SimpleHealthCheck;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.features.telemetry.adapters.registry.api.TelemetryAdapterRegistry;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.telemetry.config.api.Adapter;
import org.opennms.netmgt.telemetry.config.api.Protocol;
import org.opennms.netmgt.telemetry.daemon.TelemetryMessageConsumer;
import org.opennms.netmgt.telemetry.distributed.common.AdapterConfigurationParser;
import org.opennms.netmgt.telemetry.distributed.common.MapBasedProtocolDef;
import org.opennms.netmgt.telemetry.distributed.common.MapUtils;
import org.opennms.netmgt.telemetry.distributed.sentinel.AdapterHealthCheck;
import org.opennms.netmgt.telemetry.ipc.TelemetrySinkModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterManager
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AdapterManager.class);
    private DistPollerDao distPollerDao;
    private Map<String, TelemetryMessageConsumer> consumersById = new LinkedHashMap<String, TelemetryMessageConsumer>();
    private Map<String, List<ServiceRegistration<HealthCheck>>> healthChecksById = new LinkedHashMap<String, List<ServiceRegistration<HealthCheck>>>();
    private TelemetryAdapterRegistry telemetryAdapterRegistry;
    private MessageConsumerManager messageConsumerManager;
    private BundleContext bundleContext;

    public String getName() {
        return "Manages telemetry adapter lifecycle.";
    }

    public void updated(String pid, Dictionary<String, ?> properties) {
        TelemetryMessageConsumer existingConsumer = this.consumersById.get(pid);
        if (existingConsumer != null) {
            LOG.info("Updating existing consumer for pid: {}", (Object)pid);
            this.deleted(pid);
        } else {
            LOG.info("Creating new consumer for pid: {}", (Object)pid);
        }
        Map parameters = MapUtils.fromDict(properties);
        MapBasedProtocolDef protocolDef = new MapBasedProtocolDef(parameters);
        List adapterDefinitions = new AdapterConfigurationParser().parse(parameters);
        this.healthChecksById.putIfAbsent(pid, new ArrayList());
        ArrayList<AdapterHealthCheck> healthChecks = new ArrayList<AdapterHealthCheck>();
        for (Adapter eachAdapter : adapterDefinitions) {
            AdapterHealthCheck healthCheck2 = new AdapterHealthCheck(eachAdapter);
            healthChecks.add(healthCheck2);
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(HealthCheck.class, (Object)healthCheck2, null);
            this.healthChecksById.get(pid).add((ServiceRegistration<HealthCheck>)serviceRegistration);
        }
        try {
            TelemetrySinkModule sinkModule = new TelemetrySinkModule((Protocol)protocolDef);
            sinkModule.setDistPollerDao(this.distPollerDao);
            TelemetryMessageConsumer consumer = new TelemetryMessageConsumer((Protocol)protocolDef, adapterDefinitions, sinkModule);
            consumer.setAdapterRegistry(this.telemetryAdapterRegistry);
            consumer.init();
            this.messageConsumerManager.registerConsumer((MessageConsumer)consumer);
            this.consumersById.put(pid, consumer);
            healthChecks.forEach(SimpleHealthCheck::markSucess);
        }
        catch (Exception e) {
            healthChecks.forEach(healthCheck -> healthCheck.markError(e));
            LOG.error("Failed to create {}", TelemetryMessageConsumer.class, (Object)e);
        }
    }

    public void deleted(String pid) {
        this.healthChecksById.get(pid).forEach(ServiceRegistration::unregister);
        TelemetryMessageConsumer existingConsumer = this.consumersById.remove(pid);
        if (existingConsumer != null) {
            try {
                LOG.info("Stopping consumer for pid: {}", (Object)pid);
                existingConsumer.destroy();
            }
            catch (Exception e) {
                LOG.error("Error occurred while stopping consumer for pid: {}", (Object)pid, (Object)e);
            }
            try {
                LOG.info("Unregistering consumer for pid: {}", (Object)pid);
                this.messageConsumerManager.unregisterConsumer((MessageConsumer)existingConsumer);
            }
            catch (Exception e) {
                LOG.error("Error occurred while unregisterung consumer for pid: {}", (Object)pid, (Object)e);
            }
        }
    }

    public void init() {
        LOG.info("{} started.", (Object)this.getClass().getSimpleName());
    }

    public void destroy() {
        new ArrayList<String>(this.consumersById.keySet()).forEach(pid -> this.deleted((String)pid));
        LOG.info("{} stopped.", (Object)this.getClass().getSimpleName());
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }

    public void setTelemetryAdapterRegistry(TelemetryAdapterRegistry telemetryAdapterRegistry) {
        this.telemetryAdapterRegistry = telemetryAdapterRegistry;
    }

    public void setMessageConsumerManager(MessageConsumerManager messageConsumerManager) {
        this.messageConsumerManager = messageConsumerManager;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

