/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.SyslogdConfiguration;
import org.opennms.netmgt.config.syslogd.SyslogdConfigurationGroup;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class SyslogdConfigFactory
implements SyslogdConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogdConfigFactory.class);
    private SyslogdConfiguration m_config;

    public SyslogdConfigFactory() throws IOException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME);
        this.m_config = (SyslogdConfiguration)JaxbUtils.unmarshal(SyslogdConfiguration.class, (Resource)new FileSystemResource(configFile));
        this.parseIncludedFiles();
    }

    public SyslogdConfigFactory(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.m_config = (SyslogdConfiguration)JaxbUtils.unmarshal(SyslogdConfiguration.class, (Reader)reader);
        }
        this.parseIncludedFiles();
    }

    @Override
    public synchronized void reload() throws IOException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME);
        this.m_config = (SyslogdConfiguration)JaxbUtils.unmarshal(SyslogdConfiguration.class, (Resource)new FileSystemResource(configFile));
        this.parseIncludedFiles();
    }

    @Override
    public synchronized int getSyslogPort() {
        return this.m_config.getConfiguration().getSyslogPort();
    }

    @Override
    public synchronized String getListenAddress() {
        return this.m_config.getConfiguration().getListenAddress().orElse(null);
    }

    @Override
    public synchronized boolean getNewSuspectOnMessage() {
        return this.m_config.getConfiguration().getNewSuspectOnMessage();
    }

    @Override
    public synchronized String getForwardingRegexp() {
        return this.m_config.getConfiguration().getForwardingRegexp().orElse(null);
    }

    @Override
    public synchronized Integer getMatchingGroupHost() {
        return this.m_config.getConfiguration().getMatchingGroupHost().orElse(null);
    }

    @Override
    public synchronized Integer getMatchingGroupMessage() {
        return this.m_config.getConfiguration().getMatchingGroupMessage().orElse(null);
    }

    @Override
    public synchronized String getParser() {
        return this.m_config.getConfiguration().getParser();
    }

    @Override
    public synchronized List<UeiMatch> getUeiList() {
        return this.m_config.getUeiMatches();
    }

    @Override
    public synchronized List<HideMatch> getHideMessages() {
        return this.m_config.getHideMatches();
    }

    @Override
    public synchronized String getDiscardUei() {
        return this.m_config.getConfiguration().getDiscardUei();
    }

    @Override
    public int getNumThreads() {
        if (this.m_config.getConfiguration().getThreads().isPresent()) {
            return (Integer)this.m_config.getConfiguration().getThreads().get();
        }
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Override
    public int getQueueSize() {
        return this.m_config.getConfiguration().getQueueSize();
    }

    @Override
    public int getBatchSize() {
        return this.m_config.getConfiguration().getBatchSize();
    }

    @Override
    public int getBatchIntervalMs() {
        return this.m_config.getConfiguration().getBatchInterval();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.m_config.getConfiguration().getTimeZone().orElse(null);
    }

    private void parseIncludedFiles() throws IOException {
        File configDir;
        try {
            configDir = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME).getParentFile();
        }
        catch (Throwable t) {
            LOG.warn("Error getting default syslogd configuration location. <import-file> directives will be ignored.  This should really only happen in unit tests.");
            return;
        }
        for (String fileName : this.m_config.getImportFiles()) {
            File configFile = new File(configDir, fileName);
            SyslogdConfigurationGroup includeCfg = (SyslogdConfigurationGroup)JaxbUtils.unmarshal(SyslogdConfigurationGroup.class, (Resource)new FileSystemResource(configFile));
            if (includeCfg.getUeiMatches() != null) {
                for (UeiMatch ueiMatch : includeCfg.getUeiMatches()) {
                    if (this.m_config.getUeiMatches() == null) {
                        this.m_config.setUeiMatches(new ArrayList());
                    }
                    this.m_config.addUeiMatch(ueiMatch);
                }
            }
            if (includeCfg.getHideMatches() == null) continue;
            for (HideMatch hideMatch : includeCfg.getHideMatches()) {
                if (this.m_config.getHideMatches() == null) {
                    this.m_config.setHideMatches(new ArrayList());
                }
                this.m_config.addHideMatch(hideMatch);
            }
        }
    }
}

