/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgePortWithMacs;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class BridgeTopologyDaoHibernate
implements BridgeTopologyDao {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeTopologyDaoHibernate.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private NodeDao m_nodeDao;
    private BridgeElementDao m_bridgeElementDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;

    public BridgeElementDao getBridgeElementDao() {
        return this.m_bridgeElementDao;
    }

    public void setBridgeElementDao(BridgeElementDao bridgeElementDao) {
        this.m_bridgeElementDao = bridgeElementDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    @Override
    public void save(BroadcastDomain domain, Date now) throws BridgeTopologyException {
        for (SharedSegment segment : domain.getSharedSegments()) {
            segment.getDesignatedPort();
        }
        for (SharedSegment segment : domain.getSharedSegments()) {
            for (BridgeBridgeLink link : SharedSegment.getBridgeBridgeLinks((SharedSegment)segment)) {
                link.setBridgeBridgeLinkLastPollTime(new Date());
                this.saveBridgeBridgeLink(link);
            }
            for (BridgeBridgeLink link : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                link.setBridgeMacLinkLastPollTime(new Date());
                this.saveBridgeMacLink((BridgeMacLink)link);
            }
        }
        domain.getForwarding().stream().filter(forward -> forward.getMacs().size() > 0).forEach(forward -> {
            for (BridgeMacLink link : BridgeForwardingTableEntry.create((BridgePortWithMacs)forward, (BridgeMacLink.BridgeMacLinkType)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER)) {
                link.setBridgeMacLinkLastPollTime(new Date());
                this.saveBridgeMacLink(link);
            }
        });
        for (Integer nodeid : domain.getBridgeNodesOnDomain()) {
            this.m_bridgeMacLinkDao.deleteByNodeIdOlderThen(nodeid, now);
            this.m_bridgeBridgeLinkDao.deleteByNodeIdOlderThen(nodeid, now);
            this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeIdOlderThen(nodeid, now);
        }
        try {
            this.m_bridgeMacLinkDao.flush();
        }
        catch (Exception e) {
            LOG.error("BridgeMacLinkDao: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.m_bridgeBridgeLinkDao.flush();
        }
        catch (Exception e) {
            LOG.error("BridgeBridgeLinkDao: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Transactional
    protected void saveBridgeMacLink(final BridgeMacLink saveMe) {
        new UpsertTemplate<BridgeMacLink, BridgeMacLinkDao>(this.m_transactionManager, this.m_bridgeMacLinkDao){

            @Override
            protected BridgeMacLink query() {
                return ((BridgeMacLinkDao)this.m_dao).getByNodeIdBridgePortMac(saveMe.getNode().getId(), saveMe.getBridgePort(), saveMe.getMacAddress());
            }

            @Override
            protected BridgeMacLink doUpdate(BridgeMacLink link) {
                link.merge(saveMe);
                ((BridgeMacLinkDao)this.m_dao).update(link);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return link;
            }

            @Override
            protected BridgeMacLink doInsert() {
                OnmsNode node = (OnmsNode)BridgeTopologyDaoHibernate.this.m_nodeDao.get(saveMe.getNode().getId());
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                if (saveMe.getBridgeMacLinkLastPollTime() == null) {
                    saveMe.setBridgeMacLinkLastPollTime(saveMe.getBridgeMacLinkCreateTime());
                }
                ((BridgeMacLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveBridgeBridgeLink(final BridgeBridgeLink saveMe) {
        new UpsertTemplate<BridgeBridgeLink, BridgeBridgeLinkDao>(this.m_transactionManager, this.m_bridgeBridgeLinkDao){

            @Override
            protected BridgeBridgeLink query() {
                return ((BridgeBridgeLinkDao)this.m_dao).getByNodeIdBridgePort(saveMe.getNode().getId(), saveMe.getBridgePort());
            }

            @Override
            protected BridgeBridgeLink doUpdate(BridgeBridgeLink link) {
                link.merge(saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).update(link);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return link;
            }

            @Override
            protected BridgeBridgeLink doInsert() {
                OnmsNode node = (OnmsNode)BridgeTopologyDaoHibernate.this.m_nodeDao.get(saveMe.getNode().getId());
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                if (saveMe.getBridgeBridgeLinkLastPollTime() == null) {
                    saveMe.setBridgeBridgeLinkLastPollTime(saveMe.getBridgeBridgeLinkCreateTime());
                }
                ((BridgeBridgeLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public Set<BroadcastDomain> load() {
        Set<BroadcastDomain> domains = this.getAllPersisted();
        for (BroadcastDomain domain : domains) {
            for (Bridge bridge : domain.getBridges()) {
                bridge.clear();
                List<BridgeElement> elems = this.m_bridgeElementDao.findByNodeId(bridge.getNodeId());
                bridge.getIdentifiers().addAll(Bridge.getIdentifier(elems));
                bridge.setDesignated(Bridge.getDesignated(elems));
            }
        }
        return domains;
    }

    @Override
    public void delete(int nodeid) {
        this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeId(nodeid);
        this.m_bridgeBridgeLinkDao.deleteByNodeId(nodeid);
        this.m_bridgeBridgeLinkDao.flush();
        this.m_bridgeMacLinkDao.deleteByNodeId(nodeid);
        this.m_bridgeMacLinkDao.flush();
    }

    @Override
    public List<SharedSegment> getBridgeSharedSegments(int nodeid) {
        ArrayList<SharedSegment> segments = new ArrayList<SharedSegment>();
        block6: for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findByDesignatedNodeId(nodeid)) {
            for (SharedSegment sharedSegment : segments) {
                if (!sharedSegment.containsPort(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                sharedSegment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)link));
                continue block6;
            }
            try {
                segments.add(SharedSegment.create((BridgeBridgeLink)link));
            }
            catch (BridgeTopologyException bridgeTopologyException) {
                LOG.error("getBridgeNodeSharedSegments: cannot create shared segment {}", (Object)bridgeTopologyException.getMessage(), (Object)bridgeTopologyException);
                return new ArrayList<SharedSegment>();
            }
        }
        HashSet<BridgePort> designated = new HashSet<BridgePort>();
        for (BridgeBridgeLink bridgeBridgeLink : this.m_bridgeBridgeLinkDao.findByNodeId(nodeid)) {
            designated.add(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)bridgeBridgeLink));
        }
        for (BridgePort bridgePort : designated) {
            block10: for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.getByDesignatedNodeIdBridgePort(bridgePort.getNodeId(), bridgePort.getBridgePort())) {
                for (SharedSegment segment : segments) {
                    if (!segment.containsPort(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                    segment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)link));
                    continue block10;
                }
                try {
                    segments.add(SharedSegment.create((BridgeBridgeLink)link));
                }
                catch (BridgeTopologyException e) {
                    LOG.error("getBridgeSharedSegments: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                    return new ArrayList<SharedSegment>();
                }
            }
        }
        block12: for (BridgeMacLink bridgeMacLink : this.m_bridgeMacLinkDao.findByNodeId(nodeid)) {
            if (bridgeMacLink.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER) continue;
            for (SharedSegment segment : segments) {
                if (!segment.containsPort(BridgePort.getFromBridgeMacLink((BridgeMacLink)bridgeMacLink))) continue;
                segment.getMacsOnSegment().add(bridgeMacLink.getMacAddress());
                continue block12;
            }
            try {
                segments.add(SharedSegment.create((BridgeMacLink)bridgeMacLink));
            }
            catch (BridgeTopologyException bridgeTopologyException) {
                LOG.error("getBridgeSharedSegments: cannot create shared segment {}", (Object)bridgeTopologyException.getMessage(), (Object)bridgeTopologyException);
                return new ArrayList<SharedSegment>();
            }
        }
        return segments;
    }

    @Override
    public SharedSegment getHostSharedSegment(String mac) {
        LOG.debug("getHostNodeSharedSegment: founding segment for mac:{}", (Object)mac);
        List links = this.m_bridgeMacLinkDao.findByMacAddress(mac).stream().filter(maclink -> maclink.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK).collect(Collectors.toCollection(ArrayList::new));
        if (links.size() == 0) {
            LOG.info("getHostNodeSharedSegment: no segment found for mac:{}", (Object)mac);
            return SharedSegment.create();
        }
        if (links.size() > 1) {
            LOG.error("getHostNodeSharedSegment: more then one segment for mac:{}", (Object)mac);
            return SharedSegment.create();
        }
        BridgeMacLink link = (BridgeMacLink)links.iterator().next();
        SharedSegment segment = null;
        try {
            for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.getByDesignatedNodeIdBridgePort(link.getNode().getId(), link.getBridgePort())) {
                if (segment == null) {
                    segment = SharedSegment.create((BridgeBridgeLink)bblink);
                    continue;
                }
                segment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)bblink));
            }
            for (BridgeMacLink maclink2 : this.m_bridgeMacLinkDao.findByNodeIdBridgePort(link.getNode().getId(), link.getBridgePort())) {
                if (segment == null) {
                    segment = SharedSegment.create((BridgeMacLink)maclink2);
                    continue;
                }
                segment.getMacsOnSegment().add(maclink2.getMacAddress());
            }
        }
        catch (Exception e) {
            LOG.error("getHostNodeSharedSegment: cannot create shared segment {} for mac {} ", new Object[]{e.getMessage(), mac, e});
            return SharedSegment.create();
        }
        return segment;
    }

    public Set<BroadcastDomain> getAllPersisted() {
        Object domain;
        ArrayList<SharedSegment> bblsegments = new ArrayList<SharedSegment>();
        HashMap<Integer, Set> rootnodetodomainnodemap = new HashMap<Integer, Set>();
        HashMap<Integer, BridgePort> designatebridgemap = new HashMap<Integer, BridgePort>();
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findAll()) {
            boolean segmentnotfound = true;
            BridgePort bridgeport = BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)link);
            designatebridgemap.put(link.getNode().getId(), bridgeport);
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                bblsegment.getBridgePortsOnSegment().add(bridgeport);
                segmentnotfound = false;
                break;
            }
            if (segmentnotfound) {
                try {
                    bblsegments.add(SharedSegment.create((BridgeBridgeLink)link));
                }
                catch (BridgeTopologyException e) {
                    LOG.error("getAllPersisted: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                    return new CopyOnWriteArraySet<BroadcastDomain>();
                }
            }
            if (rootnodetodomainnodemap.containsKey(link.getDesignatedNode().getId())) {
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
                if (!rootnodetodomainnodemap.containsKey(link.getNode().getId())) continue;
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).addAll((Collection)rootnodetodomainnodemap.remove(link.getNode().getId()));
                continue;
            }
            if (rootnodetodomainnodemap.containsKey(link.getNode().getId())) {
                Set dependentsnode = (Set)rootnodetodomainnodemap.remove(link.getNode().getId());
                dependentsnode.add(link.getNode().getId());
                Object rootdesignated = null;
                for (Integer rootid : rootnodetodomainnodemap.keySet()) {
                    if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                    rootdesignated = rootid;
                    break;
                }
                if (rootdesignated != null) {
                    dependentsnode.add(link.getDesignatedNode().getId());
                    ((Set)rootnodetodomainnodemap.get(rootdesignated)).addAll(dependentsnode);
                    continue;
                }
                rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), dependentsnode);
                continue;
            }
            Object rootdesignated = null;
            for (Object rootid : rootnodetodomainnodemap.keySet()) {
                if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                rootdesignated = rootid;
                break;
            }
            if (rootdesignated != null) {
                ((Set)rootnodetodomainnodemap.get(rootdesignated)).add(link.getNode().getId());
                continue;
            }
            rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), new HashSet());
            ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
        }
        LOG.info("getAllPersisted: bridge topology node set: {}", rootnodetodomainnodemap);
        ArrayList<SharedSegment> bmlsegments = new ArrayList<SharedSegment>();
        ArrayList<BridgeMacLink> forwarders = new ArrayList<BridgeMacLink>();
        block8: for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            if (link.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER) {
                forwarders.add(link);
                continue;
            }
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(BridgePort.getFromBridgeMacLink((BridgeMacLink)link))) continue;
                bblsegment.getMacsOnSegment().add(link.getMacAddress());
                continue block8;
            }
            for (SharedSegment bmlsegment : bmlsegments) {
                if (!bmlsegment.containsPort(BridgePort.getFromBridgeMacLink((BridgeMacLink)link))) continue;
                bmlsegment.getMacsOnSegment().add(link.getMacAddress());
                continue block8;
            }
            try {
                bmlsegments.add(SharedSegment.create((BridgeMacLink)link));
            }
            catch (BridgeTopologyException e) {
                LOG.error("getAllPersisted: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                return new CopyOnWriteArraySet<BroadcastDomain>();
            }
        }
        CopyOnWriteArraySet<BroadcastDomain> domains = new CopyOnWriteArraySet<BroadcastDomain>();
        for (Integer rootnode : rootnodetodomainnodemap.keySet()) {
            domain = new BroadcastDomain();
            Bridge.createRootBridge((BroadcastDomain)domain, (Integer)rootnode);
            for (Integer bridgenodeId : (Set)rootnodetodomainnodemap.get(rootnode)) {
                Bridge.create((BroadcastDomain)domain, (Integer)bridgenodeId, (Integer)((BridgePort)designatebridgemap.get(bridgenodeId)).getBridgePort());
            }
            domains.add((BroadcastDomain)domain);
        }
        for (SharedSegment segment : bblsegments) {
            BroadcastDomain cdomain;
            domain = domains.iterator();
            while (domain.hasNext() && !BroadcastDomain.loadTopologyEntry((BroadcastDomain)(cdomain = (BroadcastDomain)domain.next()), (SharedSegment)segment)) {
            }
        }
        block15: for (SharedSegment segment : bmlsegments) {
            for (BroadcastDomain cdomain : domains) {
                if (!BroadcastDomain.loadTopologyEntry((BroadcastDomain)cdomain, (SharedSegment)segment)) continue;
                continue block15;
            }
            domain = new BroadcastDomain();
            Bridge.createRootBridge((BroadcastDomain)domain, (Integer)segment.getDesignatedBridge());
            BroadcastDomain.loadTopologyEntry((BroadcastDomain)domain, (SharedSegment)segment);
            domains.add((BroadcastDomain)domain);
        }
        block17: for (BridgeMacLink forwarder : forwarders) {
            for (BroadcastDomain domain2 : domains) {
                Bridge bridge = domain2.getBridge(forwarder.getNode().getId().intValue());
                if (bridge == null) continue;
                domain2.addForwarding(BridgePort.getFromBridgeMacLink((BridgeMacLink)forwarder), forwarder.getMacAddress());
                continue block17;
            }
        }
        return domains;
    }
}

