/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.adapters.netflow.v9;

import java.util.Objects;
import org.bson.BsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.adapters.netflow.BsonUtils;

class Netflow9Flow
implements Flow {
    private final BsonDocument document;

    public Netflow9Flow(BsonDocument document) {
        this.document = Objects.requireNonNull(document);
    }

    public long getTimestamp() {
        return BsonUtils.getInt64(this.document, "@unixSecs").get() * 1000L;
    }

    public Long getBytes() {
        return BsonUtils.getInt64(this.document, "IN_BYTES").orElse(null);
    }

    public Flow.Direction getDirection() {
        return BsonUtils.getInt64(this.document, "DIRECTION").map(v -> v == 0L ? Flow.Direction.INGRESS : (v == 1L ? Flow.Direction.EGRESS : null)).orElse(null);
    }

    public String getDstAddr() {
        return BsonUtils.first(BsonUtils.getString(this.document, "IPV6_DST_ADDR"), BsonUtils.getString(this.document, "IPV4_DST_ADDR")).orElse(null);
    }

    public Integer getDstAs() {
        return BsonUtils.getInt64(this.document, "DST_AS").map(Long::intValue).orElse(null);
    }

    public Integer getDstMaskLen() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "IPV6_DST_MASK"), BsonUtils.getInt64(this.document, "DST_MASK")).map(Long::intValue).orElse(null);
    }

    public Integer getDstPort() {
        return BsonUtils.getInt64(this.document, "L4_DST_PORT").map(Long::intValue).orElse(null);
    }

    public Integer getEngineId() {
        return BsonUtils.getInt64(this.document, "ENGINE_ID").map(Long::intValue).orElse(null);
    }

    public Integer getEngineType() {
        return BsonUtils.getInt64(this.document, "ENGINE_TYPE").map(Long::intValue).orElse(null);
    }

    public Long getFirstSwitched() {
        return BsonUtils.getInt64(this.document, "FIRST_SWITCHED").map(t -> this.getBootTime() + t).orElse(null);
    }

    public int getFlowRecords() {
        return BsonUtils.getInt64(this.document, "@recordCount").map(Long::intValue).orElse(0);
    }

    public long getFlowSeqNum() {
        return BsonUtils.getInt64(this.document, "@sequenceNumber").orElse(0L);
    }

    public Integer getInputSnmp() {
        return BsonUtils.getInt64(this.document, "INPUT_SNMP").map(Long::intValue).orElse(null);
    }

    public Integer getIpProtocolVersion() {
        return BsonUtils.getInt64(this.document, "IP_PROTOCOL_VERSION").map(Long::intValue).orElse(null);
    }

    public Long getLastSwitched() {
        return BsonUtils.getInt64(this.document, "LAST_SWITCHED").map(t -> this.getBootTime() + t).orElse(null);
    }

    public String getNextHop() {
        return BsonUtils.first(BsonUtils.getString(this.document, "IPV6_NEXT_HOP"), BsonUtils.getString(this.document, "IPV4_NEXT_HOP"), BsonUtils.getString(this.document, "BPG_IPV6_NEXT_HOP"), BsonUtils.getString(this.document, "BPG_IPV4_NEXT_HOP")).orElse(null);
    }

    public Integer getOutputSnmp() {
        return BsonUtils.getInt64(this.document, "OUTPUT_SNMP").map(Long::intValue).orElse(null);
    }

    public Long getPackets() {
        return BsonUtils.getInt64(this.document, "IN_PKTS").orElse(null);
    }

    public Integer getProtocol() {
        return BsonUtils.getInt64(this.document, "PROTOCOL").map(Long::intValue).orElse(null);
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        int samplingAlgorithm = BsonUtils.getInt64(this.document, "SAMPLING_ALGORITHM").map(Long::intValue).orElse(0);
        if (samplingAlgorithm == 1) {
            return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
        }
        if (samplingAlgorithm == 2) {
            return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        return BsonUtils.getInt64(this.document, "SAMPLING_INTERVAL").map(Long::doubleValue).orElse(null);
    }

    public String getSrcAddr() {
        return BsonUtils.first(BsonUtils.getString(this.document, "IPV6_SRC_ADDR"), BsonUtils.getString(this.document, "IPV4_SRC_ADDR")).orElse(null);
    }

    public Integer getSrcAs() {
        return BsonUtils.getInt64(this.document, "SRC_AS").map(Long::intValue).orElse(null);
    }

    public Integer getSrcMaskLen() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "IPV6_SRC_MASK"), BsonUtils.getInt64(this.document, "SRC_MASK")).map(Long::intValue).orElse(null);
    }

    public Integer getSrcPort() {
        return BsonUtils.getInt64(this.document, "L4_SRC_PORT").map(Long::intValue).orElse(null);
    }

    public Integer getTcpFlags() {
        return BsonUtils.getInt64(this.document, "TCP_FLAGS").map(Long::intValue).orElse(null);
    }

    public Integer getTos() {
        return BsonUtils.getInt64(this.document, "TOS").map(Long::intValue).orElse(null);
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.V9;
    }

    public Integer getVlan() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "SRC_VLAN"), BsonUtils.getInt64(this.document, "DST_VLAN")).map(Long::intValue).orElse(null);
    }

    private long getSysUpTime() {
        return BsonUtils.getInt64(this.document, "@sysUpTime").get();
    }

    private long getBootTime() {
        return this.getTimestamp() - this.getSysUpTime();
    }
}

