/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.search;

import org.opennms.newts.api.search.BooleanQuery;
import org.opennms.newts.api.search.Operator;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.Term;
import org.opennms.newts.api.search.TermQuery;

public class QueryBuilder {
    private QueryBuilder() {
    }

    public static Query matchAllValues(String ... values) {
        BooleanQuery query = new BooleanQuery();
        Operator op = Operator.OR;
        for (String value : values) {
            query.add(new TermQuery(new Term(value)), op);
            op = Operator.AND;
        }
        return query;
    }

    public static Query matchAnyValue(String ... values) {
        BooleanQuery query = new BooleanQuery();
        for (String value : values) {
            query.add(new TermQuery(new Term(value)), Operator.OR);
        }
        return query;
    }

    public static Query matchKeyAndValue(String key, String value) {
        return new TermQuery(new Term(key, value));
    }
}

