/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.search;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opennms.newts.api.search.BooleanClause;
import org.opennms.newts.api.search.Operator;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.TermQuery;

public class BooleanQuery
extends Query {
    private final List<BooleanClause> m_clauses;

    public BooleanQuery() {
        this(new ArrayList<BooleanClause>());
    }

    public BooleanQuery(List<BooleanClause> clauses) {
        this.m_clauses = clauses;
    }

    public void add(Query query, Operator op) {
        this.m_clauses.add(new BooleanClause(query, op));
    }

    public void add(BooleanClause clause) {
        this.m_clauses.add(clause);
    }

    public List<BooleanClause> getClauses() {
        return this.m_clauses;
    }

    @Override
    public BooleanQuery rewrite() {
        if (!this.needsRewrite()) {
            return this;
        }
        ArrayList booleanClauses = Lists.newArrayList();
        for (BooleanClause clause : this.m_clauses) {
            Query query = clause.getQuery();
            if (query instanceof BooleanQuery || query instanceof TermQuery) {
                booleanClauses.add(clause);
                continue;
            }
            booleanClauses.add(new BooleanClause(query.rewrite(), clause.getOperator()));
        }
        return new BooleanQuery(booleanClauses);
    }

    private boolean needsRewrite() {
        for (BooleanClause clause : this.m_clauses) {
            Query query = clause.getQuery();
            if (query instanceof BooleanQuery || query instanceof TermQuery) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)obj;
        return Objects.equal(this.m_clauses, other.m_clauses);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_clauses});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (BooleanClause clause : this.m_clauses) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
                sb.append((Object)clause.getOperator());
                sb.append(" ");
            }
            sb.append("(");
            sb.append(clause.toString());
            sb.append(")");
        }
        return sb.toString();
    }
}

