/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.ByteBuffer;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.api.FetchRequestBuilder;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.Request$;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.MessageFormatter;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.tools.DefaultMessageFormatter;
import kafka.tools.SimpleConsumerShell$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SimpleConsumerShell$
implements Logging {
    public static final SimpleConsumerShell$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new SimpleConsumerShell$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SimpleConsumerShell$ simpleConsumerShell$ = this;
        synchronized (simpleConsumerShell$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int UseLeaderReplica() {
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        void var34_34;
        void var18_18;
        this.warn((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "WARNING: SimpleConsumerShell is deprecated and will be dropped in a future release following 0.11.0.0.";
            }
        });
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionIdOpt = parser.accepts("partition", "The partition to consume from.").withRequiredArg().describedAs("partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec replicaIdOpt = parser.accepts("replica", "The replica id to consume from, default -1 means leader broker.").withRequiredArg().describedAs("replica id").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(this.UseLeaderReplica()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec offsetOpt = parser.accepts("offset", "The offset id to consume from, default to -2 which means from beginning; while value -1 means from end").withRequiredArg().describedAs("consume offset").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(OffsetRequest$.MODULE$.EarliestTime()), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec clientIdOpt = parser.accepts("clientId", "The ID of this client.").withRequiredArg().describedAs("clientId").ofType(String.class).defaultsTo((Object)"SimpleConsumerShell", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetchsize", "The fetch size of each request.").withRequiredArg().describedAs("fetchsize").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec messageFormatterOpt = parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec messageFormatterArgOpt = parser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSpecBuilder printOffsetOpt = parser.accepts("print-offsets", "Print the offsets returned by the iterator");
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxMessagesOpt = parser.accepts("max-messages", "The number of messages to consume").withRequiredArg().describedAs("max-messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
        OptionSpecBuilder skipMessageOnErrorOpt = parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
        OptionSpecBuilder noWaitAtEndOfLogOpt = parser.accepts("no-wait-at-logend", "If set, when the simple consumer reaches the end of the Log, it will stop, not waiting for new produced messages");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A low-level tool for fetching data directly from a particular replica.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        int partitionId = (Integer)options.valueOf((OptionSpec)partitionIdOpt);
        int replicaId = (Integer)options.valueOf((OptionSpec)replicaIdOpt);
        LongRef startingOffset = LongRef.create((long)((Long)options.valueOf((OptionSpec)offsetOpt)));
        int fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        String clientId = ((String)options.valueOf((OptionSpec)clientIdOpt)).toString();
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        int maxMessages = (Integer)options.valueOf((OptionSpec)maxMessagesOpt);
        boolean skipMessageOnError = options.has((OptionSpec)skipMessageOnErrorOpt);
        boolean printOffsets = options.has((OptionSpec)printOffsetOpt);
        boolean noWaitAtEndOfLog = options.has((OptionSpec)noWaitAtEndOfLogOpt);
        Class<?> messageFormatterClass = Class.forName((String)options.valueOf((OptionSpec)messageFormatterOpt));
        Properties formatterArgs = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)messageFormatterArgOpt)).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        FetchRequestBuilder fetchRequestBuilder = new FetchRequestBuilder().clientId(clientId).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWaitMs).minBytes(ConsumerConfig$.MODULE$.MinFetchBytes());
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Getting topic metadata...";
            }
        });
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata.size() == 1 && ((TopicMetadata)topicsMetadata.head()).topic().equals(topic)) {
            Seq<PartitionMetadata> partitionsMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
            Option partitionMetadataOpt = partitionsMetadata.find((Function1)new Serializable(partitionId){
                public static final long serialVersionUID = 0L;
                private final int partitionId$1;

                public final boolean apply(PartitionMetadata p) {
                    return p.partitionId() == this.partitionId$1;
                }
                {
                    this.partitionId$1 = partitionId$1;
                }
            });
            if (partitionMetadataOpt.isEmpty()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId), topic})));
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            ObjectRef fetchTargetBroker = ObjectRef.create(null);
            Option replicaOpt = null;
            if (replicaId == this.UseLeaderReplica()) {
                replicaOpt = ((PartitionMetadata)partitionMetadataOpt.get()).leader();
                if (replicaOpt.isEmpty()) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: user specifies to fetch from leader for partition (%s, %d) which has not been elected yet")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId)})));
                    throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                }
            } else {
                Seq<BrokerEndPoint> replicasForPartition2 = ((PartitionMetadata)partitionMetadataOpt.get()).replicas();
                replicaOpt = replicasForPartition2.find((Function1)new Serializable(replicaId){
                    public static final long serialVersionUID = 0L;
                    private final int replicaId$1;

                    public final boolean apply(BrokerEndPoint r) {
                        return r.id() == this.replicaId$1;
                    }
                    {
                        this.replicaId$1 = replicaId$1;
                    }
                });
                if (replicaOpt.isEmpty()) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: replica %d does not exist for partition (%s, %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
                    throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                }
            }
            fetchTargetBroker.elem = (BrokerEndPoint)replicaOpt.get();
            if (startingOffset.elem < OffsetRequest$.MODULE$.EarliestTime()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Invalid starting offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startingOffset.elem)})));
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (startingOffset.elem < 0L) {
                SimpleConsumer simpleConsumer = new SimpleConsumer(((BrokerEndPoint)fetchTargetBroker.elem).host(), ((BrokerEndPoint)fetchTargetBroker.elem).port(), ConsumerConfig$.MODULE$.SocketTimeout(), ConsumerConfig$.MODULE$.SocketBufferSize(), clientId);
                try {
                    startingOffset.elem = simpleConsumer.earliestOrLatestOffset(new TopicAndPartition(topic, partitionId), startingOffset.elem, Request$.MODULE$.DebuggingConsumerId());
                    if (simpleConsumer != null) {
                        simpleConsumer.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        System.err.println(new StringBuilder().append((Object)"Error in getting earliest or latest offset due to: ").append((Object)Utils.stackTrace((Throwable)throwable)).toString());
                        throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable throwable2) {
                        if (simpleConsumer != null) {
                            simpleConsumer.close();
                        }
                        throw throwable2;
                    }
                }
            }
            MessageFormatter formatter = (MessageFormatter)messageFormatterClass.newInstance();
            formatter.init(formatterArgs);
            String replicaString = replicaId > 0 ? "leader" : "replica";
            this.info((Function0<String>)new Serializable(topic, partitionId, replicaId, startingOffset, fetchTargetBroker, replicaString){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionId$1;
                private final int replicaId$1;
                private final LongRef startingOffset$1;
                private final ObjectRef fetchTargetBroker$1;
                private final String replicaString$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Starting simple consumer shell to partition [%s, %d], %s [%d], host and port: [%s, %d], from offset [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), this.replicaString$1, BoxesRunTime.boxToInteger((int)this.replicaId$1), ((BrokerEndPoint)this.fetchTargetBroker$1.elem).host(), BoxesRunTime.boxToInteger((int)((BrokerEndPoint)this.fetchTargetBroker$1.elem).port()), BoxesRunTime.boxToLong((long)this.startingOffset$1.elem)}));
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionId$1 = partitionId$1;
                    this.replicaId$1 = replicaId$1;
                    this.startingOffset$1 = startingOffset$1;
                    this.fetchTargetBroker$1 = fetchTargetBroker$1;
                    this.replicaString$1 = replicaString$1;
                }
            });
            SimpleConsumer simpleConsumer2 = new SimpleConsumer(((BrokerEndPoint)fetchTargetBroker.elem).host(), ((BrokerEndPoint)fetchTargetBroker.elem).port(), 10000, 65536, clientId);
            KafkaThread thread = KafkaThread.nonDaemon((String)"kafka-simpleconsumer-shell", (Runnable)new Runnable(topic, partitionId, replicaId, startingOffset, fetchSize, maxMessages, skipMessageOnError, printOffsets, noWaitAtEndOfLog, fetchRequestBuilder, formatter, simpleConsumer2){
                public final String topic$1;
                public final int partitionId$1;
                public final int replicaId$1;
                private final LongRef startingOffset$1;
                private final int fetchSize$1;
                public final int maxMessages$1;
                public final boolean skipMessageOnError$1;
                public final boolean printOffsets$1;
                private final boolean noWaitAtEndOfLog$1;
                private final FetchRequestBuilder fetchRequestBuilder$1;
                public final MessageFormatter formatter$1;
                public final SimpleConsumer simpleConsumer$1;

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    block6: {
                        offset = LongRef.create((long)this.startingOffset$1.elem);
                        numMessagesConsumed = IntRef.create((int)0);
                        while (true) {
                            if (numMessagesConsumed.elem >= this.maxMessages$1) break block6;
                            fetchRequest = this.fetchRequestBuilder$1.addFetch(this.topic$1, this.partitionId$1, offset.elem, this.fetchSize$1).build();
                            fetchResponse = this.simpleConsumer$1.fetch(fetchRequest);
                            messageSet = fetchResponse.messageSet(this.topic$1, this.partitionId$1);
                            if (messageSet.validBytes() > 0 || !this.noWaitAtEndOfLog$1) ** break block7
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Terminating. Reached the end of partition (%s, %d) at offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), BoxesRunTime.boxToLong((long)offset.elem)})));
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)new Serializable(this, numMessagesConsumed){
                                public static final long serialVersionUID = 0L;
                                private final IntRef numMessagesConsumed$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numMessagesConsumed$1.elem)}));
                                }
                                {
                                    this.numMessagesConsumed$1 = numMessagesConsumed$1;
                                }
                            });
                            return;
                            break;
                        }
                        {
                            catch (Throwable var3_6) {
                                SimpleConsumerShell$.MODULE$.error((Function0<String>)new Serializable(this, offset){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anon.1 $outer;
                                    private final LongRef offset$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Error consuming topic, partition, replica (%s, %d, %d) with offset [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.partitionId$1), BoxesRunTime.boxToInteger((int)this.$outer.replicaId$1), BoxesRunTime.boxToLong((long)this.offset$1.elem)}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.offset$1 = offset$1;
                                    }
                                }, (Function0<Throwable>)new Serializable(this, var3_6){
                                    public static final long serialVersionUID = 0L;
                                    private final Throwable e$2;

                                    public final Throwable apply() {
                                        return this.e$2;
                                    }
                                    {
                                        this.e$2 = e$2;
                                    }
                                });
                            }
                        }
                        {
                            SimpleConsumerShell$.MODULE$.debug((Function0<String>)new Serializable(this, offset, messageSet){
                                public static final long serialVersionUID = 0L;
                                private final LongRef offset$1;
                                private final ByteBufferMessageSet messageSet$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"multi fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.messageSet$1.sizeInBytes())).append((Object)" bytes from offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString();
                                }
                                {
                                    this.offset$1 = offset$1;
                                    this.messageSet$1 = messageSet$1;
                                }
                            });
                            messageSet.withFilter((Function1<MessageAndOffset, Object>)new Serializable(this, numMessagesConsumed){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon.1 $outer;
                                private final IntRef numMessagesConsumed$1;

                                public final boolean apply(MessageAndOffset messageAndOffset) {
                                    return this.numMessagesConsumed$1.elem < this.$outer.maxMessages$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.numMessagesConsumed$1 = numMessagesConsumed$1;
                                }
                            }).foreach((Function1)new Serializable(this, offset, numMessagesConsumed){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon.1 $outer;
                                private final LongRef offset$1;
                                private final IntRef numMessagesConsumed$1;

                                public final void apply(MessageAndOffset messageAndOffset) {
                                    Throwable throwable2;
                                    block4: {
                                        try {
                                            Message message;
                                            this.offset$1.elem = messageAndOffset.nextOffset();
                                            if (this.$outer.printOffsets$1) {
                                                System.out.println(new StringBuilder().append((Object)"next offset = ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString());
                                            }
                                            byte[] key = (message = messageAndOffset.message()).hasKey() ? Utils.readBytes((ByteBuffer)message.key()) : null;
                                            byte[] value2 = message.isNull() ? null : Utils.readBytes((ByteBuffer)message.payload());
                                            int serializedKeySize = message.hasKey() ? Predef$.MODULE$.byteArrayOps(key).size() : -1;
                                            int serializedValueSize = message.isNull() ? -1 : Predef$.MODULE$.byteArrayOps(value2).size();
                                            this.$outer.formatter$1.writeTo((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(this.$outer.topic$1, this.$outer.partitionId$1, this.offset$1.elem, message.timestamp(), message.timestampType(), message.checksum(), serializedKeySize, serializedValueSize, (Object)key, (Object)value2), System.out);
                                            ++this.numMessagesConsumed$1.elem;
                                        }
                                        catch (Throwable throwable2) {
                                            if (!this.$outer.skipMessageOnError$1) break block4;
                                            SimpleConsumerShell$.MODULE$.error((Function0<String>)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply() {
                                                    return "Error processing message, skipping this message: ";
                                                }
                                            }, (Function0<Throwable>)new Serializable(this, throwable2){
                                                public static final long serialVersionUID = 0L;
                                                private final Throwable e$1;

                                                public final Throwable apply() {
                                                    return this.e$1;
                                                }
                                                {
                                                    this.e$1 = e$1;
                                                }
                                            });
                                        }
                                        if (System.out.checkError()) {
                                            System.err.println("Unable to write to standard out, closing consumer.");
                                            this.$outer.formatter$1.close();
                                            this.$outer.simpleConsumer$1.close();
                                            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                                        }
                                        return;
                                    }
                                    throw throwable2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.offset$1 = offset$1;
                                    this.numMessagesConsumed$1 = numMessagesConsumed$1;
                                }
                            });
                            continue;
                        }
                        catch (Throwable var4_7) {
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                            throw var4_7;
                        }
                    }
                    SimpleConsumerShell$.MODULE$.info((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionId$1 = partitionId$1;
                    this.replicaId$1 = replicaId$1;
                    this.startingOffset$1 = startingOffset$1;
                    this.fetchSize$1 = fetchSize$1;
                    this.maxMessages$1 = maxMessages$1;
                    this.skipMessageOnError$1 = skipMessageOnError$1;
                    this.printOffsets$1 = printOffsets$1;
                    this.noWaitAtEndOfLog$1 = noWaitAtEndOfLog$1;
                    this.fetchRequestBuilder$1 = fetchRequestBuilder$1;
                    this.formatter$1 = formatter$1;
                    this.simpleConsumer$1 = simpleConsumer$1;
                }
            });
            thread.start();
            thread.join();
            System.out.flush();
            formatter.close();
            simpleConsumer2.close();
            return;
        }
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s, what we get from server is only: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var18_18, var34_34})));
        throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
    }

    private SimpleConsumerShell$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

