/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.vmmgr.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusGetter {
    private static final Logger LOG = LoggerFactory.getLogger(StatusGetter.class);
    private Status m_status = Status.UNKNOWN;
    private final Controller m_controller;

    public StatusGetter(Controller controller) {
        this.m_controller = controller;
    }

    public Status getStatus() {
        return this.m_status;
    }

    public void queryStatus() throws Exception {
        Pattern p = Pattern.compile("Status: OpenNMS:Name=(\\S+) = (\\S+)");
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        List statusResults = Collections.emptyList();
        try {
            statusResults = (List)this.m_controller.doInvokeOperation("status");
        }
        catch (Throwable e) {
            LOG.debug("Could not fetch status: " + e.getMessage());
            if (this.m_controller.isVerbose()) {
                System.out.println("Could not connect to the OpenNMS JVM (OpenNMS might not be running or could be starting up or shutting down): " + e.getMessage());
            }
            this.m_status = Status.CONNECTION_REFUSED;
            return;
        }
        for (String result : statusResults) {
            Matcher m = p.matcher(result);
            if (!m.matches()) {
                throw new Exception("Result \"" + result + "\" does not match our regular expression");
            }
            results.put(m.group(1), m.group(2));
        }
        String spaces = "               ";
        int running = 0;
        int services = 0;
        for (Map.Entry entry : results.entrySet()) {
            String daemon = (String)entry.getKey();
            String status = ((String)entry.getValue()).toLowerCase();
            ++services;
            if (status.equals("running")) {
                ++running;
            }
            if (!this.m_controller.isVerbose()) continue;
            System.out.println("OpenNMS." + daemon + spaces.substring(daemon.length()) + ": " + status);
        }
        this.m_status = services == 0 ? Status.NOT_RUNNING : (running != services ? Status.PARTIALLY_RUNNING : Status.RUNNING);
    }

    public static enum Status {
        UNKNOWN,
        RUNNING,
        PARTIALLY_RUNNING,
        NOT_RUNNING,
        CONNECTION_REFUSED;

    }
}

