/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.cache;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opennms.core.cache.CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache<K, V> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CacheConfig config;
    private final CacheLoader<K, V> cacheLoader;
    private LoadingCache<K, V> delegate;

    public Cache(CacheConfig config, CacheLoader<K, V> cacheLoader) {
        this.config = Objects.requireNonNull(config);
        this.cacheLoader = Objects.requireNonNull(cacheLoader);
        config.validate();
        this.logger.debug("Cache cache.{} is {}", (Object)config.getName(), (Object)config.isEnabled());
        if (config.isEnabled()) {
            this.delegate = config.createBuilder().build(cacheLoader);
        }
        if (this.delegate != null) {
            if (config.isRecordStats()) {
                this.logger.debug("Recording of \"{}\" cache statistics is enabled.", (Object)config.getName());
                MetricRegistry registry = config.getMetricRegistry();
                registry.register(MetricRegistry.name((String)("cache." + config.getName() + ".evictionCount"), (String[])new String[0]), (Metric)((Gauge)() -> this.delegate.stats().evictionCount()));
                registry.register(MetricRegistry.name((String)("cache." + config.getName() + ".hitRate"), (String[])new String[0]), (Metric)((Gauge)() -> this.delegate.stats().hitRate()));
                registry.register(MetricRegistry.name((String)("cache." + config.getName() + ".loadExceptionCount"), (String[])new String[0]), (Metric)((Gauge)() -> this.delegate.stats().loadExceptionCount()));
            } else {
                this.logger.debug("Recording of \"{}\" cache statistics is disabled.", (Object)config.getName());
            }
        }
    }

    public V get(K key) throws ExecutionException {
        Objects.requireNonNull(key);
        if (this.config.isEnabled()) {
            return (V)this.delegate.get(key);
        }
        try {
            return (V)this.cacheLoader.load(key);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void invalidateAll() {
        if (this.delegate != null) {
            this.delegate.invalidateAll();
        }
    }

    public void refresh(K key) {
        if (this.delegate != null) {
            this.delegate.refresh(key);
        }
    }
}

