/*! backshift 1.2.2 - built on 2017-01-19 */
Function.prototype.bind||(Function.prototype.bind=function(oThis){if("function"!=typeof this)throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");var aArgs=Array.prototype.slice.call(arguments,1),fToBind=this,fNOP=function(){},fBound=function(){return fToBind.apply(this instanceof fNOP&&oThis?this:oThis,aArgs.concat(Array.prototype.slice.call(arguments)))};return fNOP.prototype=this.prototype,fBound.prototype=new fNOP,fBound});var Backshift=Backshift||{};Backshift.namespace=function(ns_string){var i,parts=ns_string.split("."),parent=Backshift;for("Backshift"===parts[0]&&(parts=parts.slice(1)),i=0;i<parts.length;i+=1)"undefined"==typeof parent[parts[i]]&&(parent[parts[i]]={}),parent=parent[parts[i]];return parent},Backshift.keys=function(obj){var keys=[];for(var key in obj)obj.hasOwnProperty(key)&&keys.push(key);return keys},Backshift.extend=function(destination,source){for(var property in source)source.hasOwnProperty(property)&&(destination[property]=source[property]);return destination},Backshift.rows=function(matrix){var ncols=matrix.length;if(0===ncols)return[];for(var nrows=matrix[0].length,rows=new Array(nrows),i=0;i<nrows;i++){for(var row=new Array(ncols),j=0;j<ncols;j++)row[j]=matrix[j][i];rows[i]=row}return rows},Backshift.fail=function(msg){throw console.log("Error: "+msg),"Error: "+msg},Backshift.clone=function(obj){return JSON.parse(JSON.stringify(obj))},function(globalContext){function isFunction(object){return _toString.call(object)===FUNCTION_CLASS}function extend(destination,source){for(var property in source)source.hasOwnProperty(property)&&(destination[property]=source[property]);return destination}function keys(object){var results=[];for(var property in object)object.hasOwnProperty(property)&&results.push(property);return results}function isUndefined(object){return"undefined"==typeof object}function argumentNames(fn){var names=fn.toString().match(/^[\s\(]*function[^(]*\(([^)]*)\)/)[1].replace(/\/\/.*?[\r\n]|\/\*(?:.|[\r\n])*?\*\//g,"").replace(/\s+/g,"").split(",");return 1!=names.length||names[0]?names:[]}function wrap(fn,wrapper){var __method=fn;return function(){var a=update([bind(__method,this)],arguments);return wrapper.apply(this,a)}}function update(array,args){for(var arrayLength=array.length,length=args.length;length--;)array[arrayLength+length]=args[length];return array}function merge(array,args){return array=slice.call(array,0),update(array,args)}function bind(fn,context){if(arguments.length<2&&isUndefined(arguments[0]))return this;var __method=fn,args=slice.call(arguments,2);return function(){var a=merge(args,arguments);return __method.apply(context,a)}}var _toString=Object.prototype.toString,FUNCTION_CLASS="[object Function]",slice=Array.prototype.slice,emptyFunction=function(){},Class=function(){function subclass(){}function create(){function klass(){this.initialize.apply(this,arguments)}var parent=null,properties=[].slice.apply(arguments);if(isFunction(properties[0])&&(parent=properties.shift()),extend(klass,Class.Methods),klass.superclass=parent,klass.subclasses=[],parent){subclass.prototype=parent.prototype,klass.prototype=new subclass;try{parent.subclasses.push(klass)}catch(e){}}for(var i=0,length=properties.length;i<length;i++)klass.addMethods(properties[i]);return klass.prototype.initialize||(klass.prototype.initialize=emptyFunction),klass.prototype.constructor=klass,klass}function addMethods(source){var ancestor=this.superclass&&this.superclass.prototype,properties=keys(source);IS_DONTENUM_BUGGY&&(source.toString!=Object.prototype.toString&&properties.push("toString"),source.valueOf!=Object.prototype.valueOf&&properties.push("valueOf"));for(var i=0,length=properties.length;i<length;i++){var property=properties[i],value=source[property];if(ancestor&&isFunction(value)&&"$super"==argumentNames(value)[0]){var method=value;value=wrap(function(m){return function(){return ancestor[m].apply(this,arguments)}}(property),method),value.valueOf=bind(method.valueOf,method),value.toString=bind(method.toString,method)}this.prototype[property]=value}return this}var IS_DONTENUM_BUGGY=function(){for(var p in{toString:1})if("toString"===p)return!1;return!0}();return{create:create,Methods:{addMethods:addMethods}}}();globalContext.exports?globalContext.exports.Class=Class:globalContext.Class=Class}(Backshift),Backshift.namespace("Backshift.Class.Configurable"),Backshift.Class.Configurable=Backshift.Class.create({configure:function(args){args=args||{},Backshift.keys(this.defaults()).forEach(function(key){return args.hasOwnProperty(key)?void(null!==this.defaults()[key]&&"object"==typeof this.defaults()[key]?Backshift.keys(this.defaults()[key]).forEach(function(k){this[key][k]=void 0!==args[key][k]?args[key][k]:void 0!==this[key][k]?this[key][k]:this.defaults()[key][k]},this):this[key]=void 0!==args[key]?args[key]:void 0!==this[key]?this[key]:this.defaults()[key]):void(this[key]=this[key]||this.defaults()[key])},this)}}),Backshift.namespace("Backshift.Utilities.RpnToJexlConverter"),Backshift.Utilities.RpnToJexlConverter=Backshift.Class.create({initialize:function(){this.operators={},this._buildOperators()},_buildOperators:function(){var simpleOp=function(op){return function(stack){var b=stack.pop(),a=stack.pop();return"("+a+" "+op+" "+b+")"}},funcOp=function(op,numArgs){return function(stack){var i,ret=op+"(";for(i=0;i<numArgs;i++)ret+=stack.pop()+",";return ret.substring(0,ret.length-1)+")"}},ifOp=function(stack){var c=stack.pop(),b=stack.pop(),a=stack.pop();return"("+a+" != 0 ? "+b+" : "+c+")"},unOp=function(stack){var a=stack.pop();return"( ("+a+" == NaN) ? 1 : 0)"},infOp=function(stack){var a=stack.pop();return"( ("+a+" == __inf) || ("+a+" == __neg_inf) ? 1 : 0)"},booleanOp=function(op){return function(stack){var b=stack.pop(),a=stack.pop();return"("+a+" "+op+" "+b+" ? 1 : 0)"}},limitOp=function(stack){var max=stack.pop(),min=stack.pop(),val=stack.pop();return"( ( ("+min+" == __inf) || ("+min+" == __neg_inf) || ("+max+" == __inf) || ("+max+" == __neg_inf) || ("+val+" == __inf) || ("+val+" == __neg_inf) || ("+val+" < "+min+") || ("+val+" > "+max+") ) ? NaN : "+val+" )"},minMaxNanOp=function(op){return function(stack){var b=stack.pop(),a=stack.pop();return"( ( "+a+" == NaN ) ? "+b+" : ( ( "+b+" == NaN ) ? "+a+" : ( "+op+"("+b+","+a+") ) ) )"}},addNanOp=function(stack){var b=stack.pop(),a=stack.pop();return"( ( ( "+a+" == NaN ) && ( "+b+" == NaN ) ) ? NaN : ( ( "+a+" == NaN ) ? "+b+" : ( ( "+b+" == NaN ) ? "+a+" : ( "+a+" + "+b+" ) ) ) )"},atan2Op=function(stack){var x=stack.pop(),y=stack.pop();return"math:atan2("+y+","+x+")"};this.operators["+"]=simpleOp("+"),this.operators["-"]=simpleOp("-"),this.operators["*"]=simpleOp("*"),this.operators["/"]=simpleOp("/"),this.operators["%"]=simpleOp("%"),this.operators.IF=ifOp,this.operators.UN=unOp,this.operators.LT=booleanOp("<"),this.operators.LE=booleanOp("<="),this.operators.GT=booleanOp(">"),this.operators.GE=booleanOp(">="),this.operators.EQ=booleanOp("=="),this.operators.NE=booleanOp("!="),this.operators.MIN=funcOp("math:min",2),this.operators.MAX=funcOp("math:max",2),this.operators.MINNAN=minMaxNanOp("math:min"),this.operators.MAXNAN=minMaxNanOp("math:max"),this.operators.ISINF=infOp,this.operators.LIMIT=limitOp,this.operators.ADDNAN=addNanOp,this.operators.SIN=funcOp("math:sin",1),this.operators.COS=funcOp("math:cos",1),this.operators.LOG=funcOp("math:log",1),this.operators.EXP=funcOp("math:exp",1),this.operators.SQRT=funcOp("math:sqrt",1),this.operators.ATAN=funcOp("math:atan",1),this.operators.ATAN2=atan2Op,this.operators.FLOOR=funcOp("math:floor",1),this.operators.CEIL=funcOp("math:ceil",1),this.operators.RAD2DEG=funcOp("math:toDegrees",1),this.operators.DEG2RAD=funcOp("math:toRadians",1),this.operators.ABS=funcOp("math:abs",1),this.operators.UNKN=function(){return"NaN"},this.operators.INF=function(){return"__inf"},this.operators.NEGINF=function(){return"__neg_inf"},this.operators["{diffTime}"]=function(){return"(__diff_time / 1000)"}},convert:function(rpn){var token,tokens,n,i,stack=[];for(tokens=rpn.split(","),n=tokens.length,i=0;i<n;i++)token=tokens[i],this._isOperator(token)?stack.push(this._toExpression(token,stack)):stack.push(token);return 1===stack.length?stack.pop():void Backshift.fail("Too many input values in RPN express. RPN: "+rpn+" Stack: "+JSON.stringify(stack))},_isOperator:function(token){return token in this.operators},_toExpression:function(token,stack){return this.operators[token](stack)}}),Backshift.namespace("Backshift.Utilities.RpnEvaluator"),Backshift.Utilities.RpnEvaluator=Backshift.Class.create({initialize:function(){this.operators={},this._buildOperators()},_valueOf:function(token,context){return token in context&&context.hasOwnProperty(token)?context[token]:parseFloat(token)},_buildOperators:function(){var self=this,funcOp=function(op,numArgs){return function(stack,context){for(var values=new Array(numArgs),i=0;i<numArgs;i++)values[i]=self._valueOf(stack.pop(),context);return values.reverse(),op.apply(null,values)}},limitOp=function(stack,context){var max=self._valueOf(stack.pop(),context),min=self._valueOf(stack.pop(),context),val=self._valueOf(stack.pop(),context);return val===Number.POSITIVE_INFINITY||val===Number.NEGATIVE_INFINITY?NaN:min==Number.POSITIVE_INFINITY||min===Number.NEGATIVE_INFINITY?NaN:max==Number.POSITIVE_INFINITY||max===Number.NEGATIVE_INFINITY?NaN:val<min||val>max?NaN:val},addNanOp=function(stack,context){var b=self._valueOf(stack.pop(),context),a=self._valueOf(stack.pop(),context);return isNaN(a)&&isNaN(b)?NaN:isNaN(a)?b:isNaN(b)?a:a+b};this.operators["+"]=funcOp(function(a,b){return a+b},2),this.operators["-"]=funcOp(function(a,b){return a-b},2),this.operators["*"]=funcOp(function(a,b){return a*b},2),this.operators["/"]=funcOp(function(a,b){return a/b},2),this.operators["%"]=funcOp(function(a,b){return a%b},2),this.operators.IF=funcOp(function(a,b,c){return 0!=a?b:c},3),this.operators.UN=funcOp(function(a){return isNaN(a)?0:1},1),this.operators.LT=funcOp(function(a,b){return a<b?1:0},2),this.operators.LE=funcOp(function(a,b){return a<=b?1:0},2),this.operators.GT=funcOp(function(a,b){return a>b?1:0},2),this.operators.GE=funcOp(function(a,b){return a>=b?1:0},2),this.operators.EQ=funcOp(function(a,b){return a==b?1:0},2),this.operators.NE=funcOp(function(a,b){return a!=b?1:0},2),this.operators.MIN=funcOp(function(a,b){return Math.min(a,b)},2),this.operators.MAX=funcOp(function(a,b){return Math.max(a,b)},2),this.operators.MINNAN=funcOp(function(a,b){return isNaN(a)?b:isNaN(b)?a:Math.min(a,b)},2),this.operators.MAXNAN=funcOp(function(a,b){return isNaN(a)?b:isNaN(b)?a:Math.max(a,b)},2),this.operators.ISINF=funcOp(function(a){return a===Number.POSITIVE_INFINITY||a===Number.NEGATIVE_INFINITY?1:0},1),this.operators.LIMIT=limitOp,this.operators.ADDNAN=addNanOp,this.operators.SIN=funcOp(function(a){return Math.sin(a)},1),this.operators.COS=funcOp(function(a){return Math.cos(a)},1),this.operators.LOG=funcOp(function(a){return Math.log(a)},1),this.operators.EXP=funcOp(function(a){return Math.exp(a)},1),this.operators.SQRT=funcOp(function(a){return Math.sqrt(a)},1),this.operators.ATAN=funcOp(function(a){return Math.atan(a)},1),this.operators.ATAN2=funcOp(function(a,b){return Math.atan(a,b)},2),this.operators.FLOOR=funcOp(function(a){return Math.floor(a)},1),this.operators.CEIL=funcOp(function(a){return Math.ceil(a)},1),this.operators.RAD2DEG=funcOp(function(a){return a*(180/Math.PI)},1),this.operators.DEG2RAD=funcOp(function(a){return a*(Math.PI/180)},1),this.operators.ABS=funcOp(function(a){return Math.abs(a)},1),this.operators.UNKN=funcOp(function(){return NaN},0),this.operators.INF=funcOp(function(){return Number.POSITIVE_INFINITY},0),this.operators.NEGINF=funcOp(function(){return Number.NEGATIVE_INFINITY},0)},evaluate:function(rpn,context){var token,tokens,n,i,stack=[];for(tokens=rpn.split(","),n=tokens.length,i=0;i<n;i++)token=tokens[i],this._isOperator(token)?stack.push(this._eval(token,stack,context)):stack.push(token);return 1===stack.length?stack.pop():void Backshift.fail("Too many input values in RPN express. RPN: "+rpn+" Stack: "+JSON.stringify(stack))},_isOperator:function(token){return token in this.operators},_eval:function(token,stack,context){return this.operators[token](stack,context)}}),Backshift.namespace("Backshift.Utilities.Consolidator"),Backshift.Utilities.Consolidator=Backshift.Class.create(function(){function valid(value){return!isNaN(value)&&isFinite(value)}function forEach(timestamps,values,cb){for(var validCount=0,i=0;i<timestamps.length;i++)valid(values[i])&&(validCount++,cb(timestamps[i],values[i]));return validCount}function wrap(func){return function(metricName,argument){return{metricName:metricName,functionName:func.name,argument:argument,consolidate:function(data){return func(data.columns[data.columnNameToIndex.timestamp],data.columns[data.columnNameToIndex[metricName]],argument)}}}}var functions={},clazz={initialize:function(){},parse:function(tokens){"string"==typeof tokens&&(tokens=tokens.split(","));var metricName=tokens.shift(),functionName=tokens.pop().toLowerCase();functionName in functions||Backshift.fail("Unknown correlation function: "+functionName),tokens.length>1&&Backshift.fail("Too many input values in RPN express. RPN: "+tokens);var argument=parseFloat(tokens[0]);return functions[functionName](metricName,argument)}};return clazz.minimum=functions.minimum=wrap(function(timestamps,values){var minimumTimestamp=void 0,minimumValue=NaN;return forEach(timestamps,values,function(timestamp,value){(isNaN(minimumValue)||value<minimumValue)&&(minimumTimestamp=timestamp,minimumValue=value)}),[minimumTimestamp,minimumValue]}),clazz.maximum=functions.maximum=wrap(function(timestamps,values){var maximumTimestamp=void 0,maximumValue=NaN;return forEach(timestamps,values,function(timestamp,value){(isNaN(maximumValue)||value>maximumValue)&&(maximumTimestamp=timestamp,maximumValue=value)}),[maximumTimestamp,maximumValue]}),clazz.average=functions.average=wrap(function(timestamps,values){var sum=0,cnt=forEach(timestamps,values,function(timestamp,value){sum+=value});return[void 0,sum/cnt]}),clazz.stdev=functions.stdev=wrap(function(timestamps,values){var sum=0,cnt=forEach(timestamps,values,function(timestamp,value){sum+=value}),avg=sum/cnt,dev=0;return forEach(timestamps,values,function(timestamp,value){dev+=Math.pow(value-avg,2)}),[void 0,Math.sqrt(dev/cnt)]}),clazz.last=functions.last=wrap(function(timestamps,values){for(var i=timestamps.length-1;i>=0;i--)if(valid(values[i]))return[timestamps[i],values[i]];return[void 0,NaN]}),clazz.first=functions.first=wrap(function(timestamps,values){for(var i=0;i<timestamps.length;i++)if(valid(values[i]))return[timestamps[i],values[i]];return[void 0,NaN]}),clazz.total=functions.total=wrap(function(timestamps,values){for(var sum=0,cnt=0,i=1;i<timestamps.length;i++)valid(values[i])&&(sum+=values[i]*(timestamps[i]-timestamps[i-1])/1e3,cnt+=1);return cnt>0?[void 0,sum]:[void 0,NaN]}),clazz.percent=functions.percent=wrap(function(timestamps,values,argument){for(var sortedValues=Array(),i=0;i<timestamps.length;i++)sortedValues.push(values[i]);return sortedValues.sort(function(a,b){return isNaN(a)?-1:isNaN(b)?1:a==Number.POSITIVE_INFINITY?1:a==Number.NEGATIVE_INFINITY?-1:b==Number.POSITIVE_INFINITY?-1:b==Number.NEGATIVE_INFINITY?1:a<b?-1:1}),[void 0,sortedValues[Math.round(argument*(sortedValues.length-1)/100)]]}),clazz.percentnan=functions.percentnan=wrap(function(timestamps,values,argument){var sortedValues=Array();return forEach(timestamps,values,function(timestamp,value){sortedValues.push(value)}),sortedValues.sort(),[void 0,sortedValues[Math.round(argument*(sortedValues.length-1)/100)]]}),functions.min=functions.minimum,functions.max=functions.maximum,clazz}()),Backshift.namespace("Backshift.Utilities.RrdGraphConverter"),Backshift.Utilities.RrdGraphVisitor=Backshift.Class.create({initialize:function(args){this.onInit(args)},onInit:function(args){},_visit:function(graphDef){var i,args,command,name,path,dsName,consolFun,rpnExpression,subParts,width,srcName,color,legend,aggregation,value,CommandLineParser=function(){var parse=function(str,lookForQuotes){for(var args=[],readingPart=!1,part="",n=str.length,i=0;i<n;i++)" "!==str.charAt(i)||readingPart?'"'===str.charAt(i)&&lookForQuotes?(readingPart=!readingPart,part+=str.charAt(i)):part+=str.charAt(i):(args.push(part),part="");return args.push(part),args};return{parse:parse}}(),parts=CommandLineParser.parse(graphDef.command,!0),n=parts.length;for(i=0;i<n;i++){if(0===parts[i].indexOf("--")){if(args=/--(.*)=(.*)/.exec(parts[i]),null===args)continue;"title"===args[1]?this._onTitle(this.displayString(this._decodeString(args[2]))):"vertical-label"===args[1]&&this._onVerticalLabel(this.displayString(this._decodeString(args[2])))}args=parts[i].match(/(\\.|[^:])+/g),null!==args&&(command=args[0],"DEF"===command?(subParts=args[1].split("="),name=subParts[0],path=subParts[1],dsName=args[2],consolFun=args[3],this._onDEF(name,path,dsName,consolFun)):"CDEF"===command?(subParts=args[1].split("="),name=subParts[0],rpnExpression=subParts[1],this._onCDEF(name,rpnExpression)):"VDEF"===command?(subParts=args[1].split("="),name=subParts[0],rpnExpression=subParts[1],this._onVDEF(name,rpnExpression)):command.match(/LINE/)?(width=parseInt(/LINE(\d+)/.exec(command)),subParts=args[1].split("#"),srcName=subParts[0],color="#"+subParts[1],legend=this._decodeString(args[2]),this._onLine(srcName,color,legend,width)):"AREA"===command?(subParts=args[1].split("#"),srcName=subParts[0],color="#"+subParts[1],legend=this._decodeString(args[2]),this._onArea(srcName,color,legend)):"STACK"===command?(subParts=args[1].split("#"),srcName=subParts[0],color="#"+subParts[1],legend=this._decodeString(args[2]),this._onStack(srcName,color,legend)):"GPRINT"===command?(3==args.length?(srcName=args[1],aggregation=void 0,value=this._decodeString(args[2])):(srcName=args[1],aggregation=args[2],value=this._decodeString(args[3])),this._onGPrint(srcName,aggregation,value)):"COMMENT"===command&&(value=this._decodeString(args[1]),this._onComment(value)))}},_onTitle:function(title){},_onVerticalLabel:function(label){},_onDEF:function(name,path,dsName,consolFun){},_onCDEF:function(name,rpnExpression){},_onVDEF:function(name,rpnExpression){},_onLine:function(srcName,color,legend,width){},_onArea:function(srcName,color,legend){},_onStack:function(srcName,color,legend){},_onGPrint:function(srcName,aggregation,value){},_onComment:function(value){},_seriesName:function(string){},_decodeString:function(string){return void 0===string?string:(string=string.replace(/"/g,""),string=string.replace("\\:",":"))},displayString:function(string){return void 0===string?string:(string=string.replace("\\n",""),string=string.trim())}}),Backshift.namespace("Backshift.Utilities.RrdGraphConverter"),Backshift.Utilities.RrdGraphConverter=Backshift.Class.create(Backshift.Utilities.RrdGraphVisitor,{onInit:function(args){this.graphDef=args.graphDef,this.resourceId=args.resourceId,this.convertRpnToJexl=void 0===args.convertRpnToJexl||args.convertRpnToJexl,this.model={metrics:[],values:[],series:[],printStatements:[],properties:{}},this.rpnConverter=new Backshift.Utilities.RpnToJexlConverter,this.consolidator=new Backshift.Utilities.Consolidator;var propertyValue,i,j,n,m;for(i=0,n=this.graphDef.propertiesValues.length;i<n;i++)propertyValue=this.graphDef.propertiesValues[i],this.model.properties[propertyValue]=void 0;for(this._visit(this.graphDef),i=0,n=this.model.values.length;i<n;i++){var metric=this.model.values[i].expression.metricName;if(void 0!==metric){var foundSeries=!1;for(j=0,m=this.model.series.length;j<m;j++)if(metric===this.model.series[j].metric){foundSeries=!0;break}if(!foundSeries){var series={metric:metric,type:"hidden"};this.model.series.push(series)}}}var nonTransientMetrics={};for(i=0,n=this.model.series.length;i<n;i++)nonTransientMetrics[this.model.series[i].metric]=1;for(i=0,n=this.model.metrics.length;i<n;i++)metric=this.model.metrics[i],metric["transient"]=!(metric.name in nonTransientMetrics)},_onTitle:function(title){this.model.title=title},_onVerticalLabel:function(label){this.model.verticalLabel=label},_onDEF:function(name,path,dsName,consolFun){var columnIndex=parseInt(/\{rrd(\d+)}/.exec(path)[1])-1,attribute=this.graphDef.columns[columnIndex];this.prefix=name,this.model.metrics.push({name:name,attribute:attribute,resourceId:this.resourceId,datasource:dsName,aggregation:consolFun})},_expressionRegexp:new RegExp("\\{([^}]*)}","g"),_onCDEF:function(name,rpnExpression){var expression=rpnExpression;this.convertRpnToJexl&&(expression=this.rpnConverter.convert(rpnExpression)),this.prefix&&(expression=expression.replace(this._expressionRegexp,this.prefix+".$1")),this.model.metrics.push({name:name,expression:expression})},_onVDEF:function(name,rpnExpression){this.model.values.push({name:name,expression:this.consolidator.parse(rpnExpression)})},_onLine:function(srcName,color,legend,width){var series={name:this.displayString(legend),metric:srcName,type:"line",color:color};this.maybeAddPrintStatementForSeries(srcName,legend),this.model.series.push(series)},_onArea:function(srcName,color,legend){var series={name:this.displayString(legend),metric:srcName,type:"area",color:color};this.maybeAddPrintStatementForSeries(srcName,legend),this.model.series.push(series)},_onStack:function(srcName,color,legend){var series={name:this.displayString(legend),metric:srcName,type:"stack",color:color,legend:legend};this.maybeAddPrintStatementForSeries(srcName,legend),this.model.series.push(series)},_onGPrint:function(srcName,aggregation,format){if("undefined"==typeof aggregation)this.model.printStatements.push({metric:srcName,format:format});else{var metricName=srcName+"_"+aggregation+"_"+Math.random().toString(36).substring(2);this.model.values.push({name:metricName,expression:this.consolidator.parse([srcName,aggregation])}),this.model.printStatements.push({metric:metricName,format:format})}},_onComment:function(format){this.model.printStatements.push({format:format})},maybeAddPrintStatementForSeries:function(series,legend){void 0!==legend&&null!==legend&&""!==legend&&this.model.printStatements.push({metric:series,value:NaN,format:"%g "+legend})}}),Backshift.namespace("Backshift.Graph"),Backshift.Graph=Backshift.Class.create(Backshift.Class.Configurable,{initialize:function(args){void 0===args.dataSource&&Backshift.fail("Graph needs a data source."),this.dataSource=args.dataSource,void 0===args.element&&Backshift.fail("Graph needs an element."),this.element=args.element,this.model=args.model||{},this.model.metrics||(this.model.metrics=[]),this.model.series||(this.model.series=[]),this.model.values||(this.model.values=[]),this.model.printStatements||(this.model.printStatements=[]),this._title=args.title||this.model.title,this._verticalLabel=args.verticalLabel||this.model.verticalLabel,this._regexes={},this._values={},this.configure(args),this.queryInProgress=!1,this.lastSuccessfulQuery=0,this.timer=null,this.onInit(args)},defaults:function(){return{width:400,height:240,resolution:0,start:0,end:0,last:0,refreshRate:0,beginOnRender:!0,stream:!0,checkInterval:15e3}},render:function(){null!==this.timer&&(clearInterval(this.timer),this.timer=null),this.onRender(),this.beginOnRender&&this.begin()},begin:function(){this.onBegin(),this.refresh(),this.createTimer(),this.stream&&this.startStreaming()},cancel:function(){this.destroyTimer(),this.stopStreaming(),this.onCancel()},resize:function(size){},destroy:function(){this.hideStatus(),this.destroyTimer(),this.onDestroy()},createTimer:function(){var self=this;self.destroyTimer(),self.timer=setInterval(function(){self.shouldRefresh()&&self.refresh()},self.checkInterval)},destroyTimer:function(){null!==this.timer&&(clearInterval(this.timer),this.timer=null)},setStart:function(start){this.start=start,this.refresh()},setEnd:function(end){this.end=end,this.refresh()},refresh:function(){var self=this;if(self.dataSource.supportsQueries()){var timeSpan=this.getTimeSpan();this.queryInProgress=!0,this.onBeforeQuery(),this.dataSource.query(timeSpan.start,timeSpan.end,this.getResolution()).then(function(results){self.queryInProgress=!1,self.lastSuccessfulQuery=Date.now(),self.updateValues(results),self.updateTextFields(results),self.onQuerySuccess(results),self.onAfterQuery()},function(reason){self.queryInProgress=!1,self.onQueryFailed(reason),self.onAfterQuery()})}},startStreaming:function(){var self=this;self.dataSource.supportsStreaming()&&!self.isStreaming&&(self.isStreaming=!0,self.dataSource.callback=function(results){self.updateValues(results),self.updateTextFields(results),self.onQuerySuccess(results)},this.dataSource.startStreaming())},stopStreaming:function(){var self=this;self.isStreaming&&(self.isStreaming=!1,self.dataSource.supportsStreaming()&&self.dataSource.stopStreaming())},updateValues:function(results){this._values={};for(var i=0;i<this.model.values.length;i++){var value=this.model.values[i];this._values[value.name]={metricName:value.expression.metricName,functionName:value.expression.functionName,argument:value.expression.argument,value:value.expression.consolidate(results)}}},updateTextFields:function(results){var value,re,self=this,title=self._title,verticalLabel=self._verticalLabel;if(self.model.properties)for(var prop in self.model.properties)self._regexes[prop]||(self._regexes[prop]=new RegExp("\\{"+prop+"}","g")),re=self._regexes[prop],value=results.constants&&results.constants[prop]?results.constants[prop]:"null",title&&(title=title.replace(re,value)),verticalLabel&&(verticalLabel=verticalLabel.replace(re,value));self.title=title,self.verticalLabel=verticalLabel},shouldRefresh:function(){return!this.queryInProgress&&(0!==this.refreshRate&&this.lastSuccessfulQuery<=Date.now()-this.refreshRate)},getTimeSpan:function(){0===this.start&&0===this.end&&0===this.last&&Backshift.fail("Graph needs start and end, or last to be non-zero.");var timeSpan={};return this.last>0?(timeSpan.end=Date.now(),timeSpan.start=timeSpan.end-this.last):(timeSpan.end=this.end,timeSpan.start=this.start),timeSpan},getResolution:function(){return this.resolution>0?this.resolution:this.width},showStatus:function(statusText){this.statusElement?this.statusElement.text(statusText):this.element&&(this.statusElement=d3.select(this.element).insert("div",":first-child"),this.statusElement.attr("align","center").attr("class","backshift-status").text(statusText))},hideStatus:function(){this.statusElement&&this.statusElement.remove()},onInit:function(args){},onRender:function(){},onBegin:function(){},onCancel:function(){},onBeforeQuery:function(){},onQuerySuccess:function(results){},onQueryFailed:function(reason){console.log("Query failed with: "+reason)},onAfterQuery:function(){},onDestroy:function(){}}),Backshift.namespace("Backshift.Graph.Flot"),Backshift.Graph.Flot=Backshift.Class.create(Backshift.Graph,{defaults:function($super){return Backshift.extend($super(),{width:"100%",height:"100%",title:void 0,verticalLabel:void 0,zoom:!0,xaxisFont:void 0,yaxisFont:void 0,legendFontSize:void 0,ticks:void 0})},onInit:function(){var container=jQuery(this.element);container.width(this.width),container.height(this.height)},showStatus:function(text){if(this.chart){var options=this.chart.getOptions(),canvas=this.chart.getCanvas();options&&(options._oldTitle||(options._oldTitle=options.title),options.title=text,options.canvas&&canvas&&this.chart.draw())}},hideStatus:function(){if(this.chart){var options=this.chart.getOptions(),canvas=this.chart.getCanvas();options&&(options._oldTitle&&(options.title=options._oldTitle,delete options._oldTitle),options.canvas&&canvas&&this.chart.draw())}},onBeforeQuery:function(){this.showStatus("Loading..."),this.doRender=!0},onQueryFailed:function(){this.showStatus("Query failed.")},onQuerySuccess:function(results){this.hideStatus(),this.doRender&&this.drawChart(results)},onRender:function(){this.doRender=!0,this.drawChart()},onCancel:function(){this.doRender=!1,this.drawChart()},_shouldStack:function(k){if("area"===this.model.series[k].type)for(var n=this.model.series.length,i=k;i<n;i++)if("stack"===this.model.series[i].type)return 1;return"stack"===this.model.series[k].type},drawChart:function(results){var self=this,container=jQuery(this.element),timestamps=[];results&&results.columns&&(timestamps=results.columns[0]);var values,i,j,numSeries,numValues,columnName,shouldStack,shouldFill,seriesValues,shouldShow,series={};for(numSeries=this.model.series.length,numValues=timestamps.length,i=1;i<numValues;i++)if(timestamps[i]<timestamps[i-1])throw"Timestamps are not properly ordered! ("+timestamps[i]+" < "+timestamps[i-1]+")";var from,to;numValues>=2&&(from=timestamps[0],to=timestamps[timestamps.length-1]),this.flotSeries=[],this.hiddenFlotSeries=[];var lastSeriesToStackWith=null;for(i=0;i<numSeries;i++){for(columnName="data"+i,series=this.model.series[i],series.metric&&results&&results.columns&&(values=results.columns[results.columnNameToIndex[series.metric]]),shouldStack=this._shouldStack(i),shouldFill="stack"===this.model.series[i].type||"area"===this.model.series[i].type,shouldShow="hidden"!==this.model.series[i].type,seriesValues=[],j=0;j<numValues;j++){var yOffset=0;shouldStack&&null!=lastSeriesToStackWith&&(yOffset=lastSeriesToStackWith.data[j][1]);var yVal=isNaN(values[j])?values[j]:values[j]+yOffset;seriesValues.push([timestamps[j],yVal,yOffset])}var flotSeries={label:series.name,color:series.color,lines:{show:!0,fill:shouldFill,fillColor:series.color},data:seriesValues,id:columnName,metric:series.metric,nodatatable:void 0===series.name||null===series.name||""===series.name};shouldShow?(this.flotSeries.push(flotSeries),shouldStack&&(lastSeriesToStackWith=flotSeries)):this.hiddenFlotSeries.push(flotSeries)}var yaxisTickFormat=d3.format(".3s"),legendStatements=[];for(i=0;i<self.model.printStatements.length;i++){var printStatement=self.model.printStatements[i];if(printStatement.metric in this._values){var value=this._values[printStatement.metric];legendStatements.push({metric:value.metricName,value:value.value[1],timestamp:value.value[0],format:printStatement.format})}else results&&legendStatements.push({metric:printStatement.metric,value:NaN,timestamp:void 0,format:printStatement.format})}var options={canvas:!0,title:self.title||"",axisLabels:{show:!0},hooks:{draw:[self.drawHook]},series:{lines:{zero:!1},bars:{fill:1,barWidth:1,zero:!1,lineWidth:0},points:{fill:1,fillColor:!1},shadowSize:1},yaxis:{tickFormatter:yaxisTickFormat},yaxes:[{position:"left",axisLabel:self.verticalLabel||"",axisLabelUseHtml:!1,axisLabelUseCanvas:!0}],xaxis:{},grid:{minBorderMargin:0,markings:[],backgroundColor:null,borderWidth:0,hoverable:!0,color:"#c8c8c8",margin:{left:0,right:0,top:25,bottom:0}},selection:{mode:"x",color:"#666"},legend:{show:!1,statements:legendStatements},hiddenSeries:this.hiddenFlotSeries,tooltip:{show:!0},datatable:{xaxis:{label:"Date/Time",format:function(x){var format=d3.time.format("%c");return format(new Date(x))}},yaxis:{ignoreColumnsWithNoLabel:!0,format:function(y){try{return yaxisTickFormat(y)}catch(err){return NaN}}}},zoom:{interactive:!0},pan:{interactive:!0}};this.addTimeAxis(options,from,to),self.xaxisFont&&(options.xaxis.font=self.getFontSpec(self.xaxisFont)),self.yaxisFont&&(options.yaxis.font=self.getFontSpec(self.yaxisFont)),self.legendFontSize&&(options.legend.style||(options.legend.style={}),options.legend.style.fontSize=this.legendFontSize),this.chart=jQuery.plot(container,this.flotSeries,options);var yaxis=this.chart.getAxes().yaxis;this.chart.ranges={yaxis:{panRange:[yaxis.min,yaxis.max],zoomRange:!1},xaxis:{panRange:[from,to],zoomRange:null}}},getFontSpec:function(fontSpec){var ret={size:"inherit",family:"inherit",style:"inherit",weight:"inherit",variant:"inherit",color:"inherit"};return fontSpec&&(fontSpec.size&&(ret.size=fontSpec.size),fontSpec.family&&(ret.family=fontSpec.family),fontSpec.style&&(ret.style=fontSpec.style),fontSpec.weight&&(ret.weight=fontSpec.weight),
fontSpec.variant&&(ret.variant=fontSpec.variant),fontSpec.color&&(ret.color=fontSpec.color)),ret},drawHook:function(plot,canvascontext){var cx=canvascontext.canvas.clientWidth/2;canvascontext.font="15px sans-serif",canvascontext.textAlign="center",canvascontext.fillText(plot.getOptions().title,cx,15)},addTimeAxis:function(options,from,to){var elem=jQuery(this.element),ticks=this.ticks||elem.width()/100;options.xaxis={mode:"time",timezone:"browser",min:from,max:to,label:"Datetime",ticks:ticks,timeformat:this.time_format(ticks,from,to)}},time_format:function(ticks,min,max){if(min&&max&&ticks){var secPerTick=(max-min)/ticks/1e3;return secPerTick<=45?"%H:%M:%S":secPerTick<=7200?"%H:%M":secPerTick<=8e4?"%m/%d %H:%M":secPerTick<=2419200?"%m/%d":"%Y-%m"}return"%H:%M"},onDestroy:function(){this.chart&&this.chart.destroy&&(this.chart.shutdown(),this.chart.destroy())}}),Backshift.namespace("Backshift.DataSource"),Backshift.DataSource=Backshift.Class.create(Backshift.Class.Configurable,{initialize:function(args){void 0!==args.metrics&&0!==args.metrics.length||Backshift.fail("DataSource needs one or more metrics."),this.metrics=args.metrics,this.configure(args),this.onInit(args)},defaults:function(){return{}},query:function(start,end,resolution,args){},supportsQueries:function(){return!0},supportsStreaming:function(){return!1},onInit:function(args){}}),Backshift.namespace("Backshift.DataSource.OpenNMS"),Backshift.DataSource.OpenNMS=Backshift.Class.create(Backshift.DataSource,{defaults:function($super){return Backshift.extend($super(),{url:"http://127.0.0.1:8980/opennms/rest/measurements",username:null,password:null,fetchFunction:null})},onInit:function(args){this.fetchFunction||(this.fetchFunction=this.post)},post:function(url,data,onSuccess,onFailure){var self=this,withCredentials=null!==self.username&&null!==self.password,headers={};withCredentials&&(headers.Authorization="Basic "+window.btoa(self.username+":"+self.password)),jQuery.ajax({url:url,xhrFields:{withCredentials:withCredentials},headers:headers,type:"POST",data:JSON.stringify(data),contentType:"application/json",dataType:"json",success:onSuccess,error:onFailure})},query:function(start,end,resolution,args){var self=this,dfd=jQuery.Deferred(),data=self._getQueryRequest(start,end,resolution),success=function(response){void 0===response&&(response={labels:[],timestamps:[],columns:[]}),dfd.resolve(self._parseResponse(response))},failure=function(jqXmr,textStatus){dfd.reject(textStatus)};return self.fetchFunction(self.url,data,success,failure),dfd.promise()},_getQueryRequest:function(start,end,resolution){var qrSource,queryRequest={start:start,end:end,step:resolution>0?Math.floor((end-start)/resolution):1,source:[],expression:[],filter:[]},timeDeltaInSeconds=end-start;return Backshift.keys(this.metrics).forEach(function(key){var metric=this.metrics[key];void 0!==metric.resourceId?(qrSource={aggregation:metric.aggregation,attribute:metric.attribute,label:metric.name,resourceId:metric.resourceId,"transient":metric["transient"]},void 0!==metric.datasource&&metric.attribute!==metric.datasource&&(qrSource.datasource=metric.datasource),queryRequest.source.push(qrSource)):"filter"===metric.type?queryRequest.filter.push({name:metric.name,parameter:metric.parameter}):(qrSource={value:metric.expression,label:metric.name,"transient":metric["transient"]},qrSource.value=qrSource.value.replace("{diffTime}",timeDeltaInSeconds),queryRequest.expression.push(qrSource))},this),0===queryRequest.source.length&&delete queryRequest.source,0===queryRequest.expression.length&&delete queryRequest.expression,0===queryRequest.filter.length&&delete queryRequest.filter,queryRequest},_parseResponse:function(json){var k,columns,columnNames,columnNameToIndex,constants,parts,numMetrics=json.labels.length;for(columns=new Array(1+numMetrics),columnNames=new Array(1+numMetrics),columnNameToIndex={},columns[0]=json.timestamps,columnNames[0]="timestamp",columnNameToIndex.timestamp=0,k=0;k<numMetrics;k++)columns[1+k]=json.columns[k].values,columnNames[1+k]=json.labels[k],columnNameToIndex[columnNames[1+k]]=1+k;if(json.constants){constants={};for(var key,value,c=0,len=json.constants.length;c<len;c++)key=json.constants[c].key,value=json.constants[c].value,parts=key.split("."),parts.length>1&&(key=parts[1],constants[key]=void 0===value?null:value)}return{columns:columns,columnNames:columnNames,columnNameToIndex:columnNameToIndex,constants:constants}}}),Backshift.namespace("Backshift.DataSource.NRTG"),Backshift.DataSource.NRTG=Backshift.Class.create(Backshift.DataSource,{defaults:function($super){return Backshift.extend($super(),{url:"http://127.0.0.1:8980/opennms/nrt/starter",callback:function(){},username:null,password:null,getFunction:null,slidingWindow:30,pollingInterval:1e3})},onInit:function(args){this.getFunction||(this.getFunction=this.get),1!==this.metrics.length&&Backshift.fail("NRTG only supports streaming a single metric."),this.lastMeasurementSet={},this.rows=[],this.pollingIntervalId=null},supportsQueries:function(){return!1},supportsStreaming:function(){return!0},startStreaming:function(){var self=this,dfd=jQuery.Deferred();return self.getFunction(this.url,{resourceId:self.metrics[0].resourceId,report:self.metrics[0].report},function(nrtgCollectionDetails){self.handleCollectionDetails(nrtgCollectionDetails),dfd.resolve()},function(jqXmr,textStatus){dfd.reject(textStatus)}),dfd.promise()},stopStreaming:function(){var self=this;null!==self.pollingIntervalId&&(clearInterval(self.pollingIntervalId),self.pollingIntervalId=null)},updatePollingInterval:function(pollingInterval){var self=this;if(self.pollingInterval=pollingInterval,null!==self.pollingIntervalId){clearInterval(self.pollingIntervalId);var poll=function(){self.poll()}.bind(self);self.pollingIntervalId=setInterval(poll,self.pollingInterval)}},updateSlidingWindow:function(slidingWindow){var self=this;self.slidingWindow=slidingWindow,self._processRowsAndNotify()},handleCollectionDetails:function(nrtgCollectionDetails){var self=this,graph={command:nrtgCollectionDetails.rrdGraphString,externalValues:[],propertiesValues:[],columns:self._metricMappingsToColumns(nrtgCollectionDetails.metricsMapping)},rrdGraphConverter=new Backshift.Utilities.RrdGraphConverter({graphDef:graph,resourceId:self.metrics[0].resourceId,convertRpnToJexl:!1});self.model=rrdGraphConverter.model,self.collectionTaskId=nrtgCollectionDetails.collectionTaskId;var poll=function(){self.poll()}.bind(self);poll(),self.pollingIntervalId=setInterval(poll,self.pollingInterval)},poll:function(){var self=this;self.pollInProgress!==!0&&(self.pollInProgress=!0,self.getFunction(self.url,{poll:!0,nrtCollectionTaskId:self.collectionTaskId},function(data){self.pollInProgress=!1,self._calculateMeasurements(data.measurement_sets),self._processRowsAndNotify()},function(jqXmr,textStatus){self.pollInProgress=!1,console.log("NRTG: Poll failed with '"+textStatus+"'.")}))},_metricMappingsToColumns:function(metricsMapping){for(var columns=[],i=1,nmetrics=Object.keys(metricsMapping).length;i<=nmetrics;i++){var found=!1;for(var key in metricsMapping)if(metricsMapping.hasOwnProperty(key)&&metricsMapping[key].indexOf("{rrd"+i+"}")>-1){columns.push(key),found=!0;break}found||Backshift.fail("Missing {rrd"+i+"}")}return columns},_calculateRate:function(lastMetric,newMetric){if(null===lastMetric||null===newMetric)return NaN;if(isNaN(lastMetric.value)||isNaN(newMetric.value))return NaN;var valueDelta=newMetric.value-lastMetric.value,timestampDeltaInMs=newMetric.timeStamp-lastMetric.timeStamp;return valueDelta/timestampDeltaInMs*1e3},_calculateMeasurements:function(measurementSets){for(var self=this,i=0,nsets=measurementSets.length;i<nsets;i++){for(var metricsById={},timestamp=0,j=0,nmetrics=measurementSets[i].length;j<nmetrics;j++){var metric=measurementSets[i][j];metricsById[metric.metricId]=metric,timestamp=metric.timeStamp}var rpnEvaluator=new Backshift.Utilities.RpnEvaluator,row={timestamp:timestamp};for(j=0,nmetrics=self.model.metrics.length;j<nmetrics;j++){var modelMetric=self.model.metrics[j],isExpression="expression"in modelMetric,value=NaN;if(isExpression)value=rpnEvaluator.evaluate(modelMetric.expression,row);else if(modelMetric.attribute in metricsById){var metric=metricsById[modelMetric.attribute];value=metric.value;var isCounter=metric.metricType.indexOf("counter")>-1;if(isCounter){var lastMetric=null;modelMetric.attribute in self.lastMeasurementSet&&(lastMetric=self.lastMeasurementSet[modelMetric.attribute]),value=self._calculateRate(lastMetric,metric)}}row[modelMetric.name]=value}self.rows.push(row),self.lastMeasurementSet=metricsById}},_processRowsAndNotify:function(){var self=this,indexOfFirstRow=0;self.slidingWindow>0&&(indexOfFirstRow=self.rows.length-self.slidingWindow,indexOfFirstRow<0&&(indexOfFirstRow=0));for(var columns={},i=indexOfFirstRow,nrows=self.rows.length;i<nrows;i++){var row=self.rows[i];for(var key in row)row.hasOwnProperty(key)&&(key in columns?columns[key].push(row[key]):columns[key]=[row[key]])}for(j=0,nmetrics=self.model.metrics.length;j<nmetrics;j++){var modelMetric=self.model.metrics[j];modelMetric["transient"]&&delete columns[modelMetric.name]}var results={columns:[],columnNames:[],columnNameToIndex:{}};$.each(columns,function(columnName,columnValues){results.columns.push(columnValues),results.columnNames.push(columnName),results.columnNameToIndex[columnName]=results.columns.length-1}),self.callback(results)},get:function(url,data,onSuccess,onFailure){var self=this,withCredentials=null!==self.username&&null!==self.password,headers={};withCredentials&&(headers.Authorization="Basic "+window.btoa(self.username+":"+self.password)),jQuery.ajax({url:url,xhrFields:{withCredentials:withCredentials},headers:headers,type:"GET",cache:!1,data:data,dataType:"json",success:onSuccess,error:onFailure})}}),"function"==typeof define&&define.amd&&define(["d3"],Backshift);